/*
 * Decompiled with CFR 0.152.
 */
package nl.codersquack.nicejs.fpsdisplay;

import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nl.codersquack.nicejs.fpsdisplay.FPSHistory;
import nl.codersquack.nicejs.fpsdisplay.config.ModConfig;
import nl.codersquack.nicejs.fpsdisplay.mixin.MixinMinecraft;
import org.apache.logging.log4j.Logger;

@Mod(modid="fpsdisplay", clientSideOnly=true)
public class FPSDisplay {
    public static final String MOD_ID = "fpsdisplay";
    private static Logger logger;
    public static Boolean SHOW_FPS_OVERLAY;
    public static FPSHistory fpsHistory;

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onPreInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
    }

    private static Integer hexColorToInt(String hexc, Integer defaultValue) {
        if (hexc == null) {
            return defaultValue;
        }
        String duck = hexc.replaceAll("^#|0x", "");
        try {
            return Integer.parseInt(duck, 16);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        logger.info("Initializing FPS-Display Mod");
        SHOW_FPS_OVERLAY = true;
        MinecraftForge.EVENT_BUS.register((Object)new FunnyEventHandler());
    }

    static {
        fpsHistory = new FPSHistory();
    }

    public static class FunnyEventHandler {
        @SubscribeEvent
        public void RenderGameOverlayEvent(RenderGameOverlayEvent event) {
            Minecraft client = Minecraft.func_71410_x();
            int fps = ((MixinMinecraft)client).getCurrentFps();
            String displayString = String.format("%d FPS (min: %d | avg: %d | max: %d)", fps, fpsHistory.getMinimum(), fpsHistory.getAverage(), fpsHistory.getMaximum());
            int w = client.field_71466_p.func_78256_a(displayString);
            client.field_71466_p.func_78276_b(displayString, ModConfig.textPosX, ModConfig.textPosY, FPSDisplay.hexColorToInt(ModConfig.textColor, 0xFFFFFF).intValue());
        }

        @SubscribeEvent
        public void ClientTickEvent(TickEvent.ClientTickEvent event) {
            Minecraft client = Minecraft.func_71410_x();
            int fps = ((MixinMinecraft)client).getCurrentFps();
            fpsHistory.add(fps);
        }
    }
}

