/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.tileentity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import superhb.arcademod.client.tileentity.ArcadeLeaderboard;

public class TileEntityArcade
extends TileEntity
implements ITickable {
    private int game = 0;
    private SoundEvent soundEvent;
    private boolean isPlaying;
    private boolean shouldStart;
    private boolean shouldStop;
    private boolean loop;
    private float volume = 1.0f;
    private ArcadeLeaderboard[] leaderboard;
    private EnergyStorage storage;
    private ArrayList<String> playerList;

    public TileEntityArcade() {
        this.game = 0;
        this.storage = new EnergyStorage(5000, 1000, 0);
        this.leaderboard = new ArcadeLeaderboard[10];
        this.playerList = new ArrayList();
    }

    public TileEntityArcade(int game) {
        this.game = game;
        this.storage = new EnergyStorage(5000, 1000, 0);
        this.leaderboard = new ArcadeLeaderboard[10];
        this.playerList = new ArrayList();
    }

    public int getGameID() {
        return this.game;
    }

    public void setGameID(int id) {
        this.game = id;
    }

    public void saveLeaderboard(ArcadeLeaderboard[] newLeaderboard) {
        this.leaderboard = newLeaderboard;
    }

    public ArcadeLeaderboard[] getLeaderboard() {
        return this.leaderboard;
    }

    public void func_73660_a() {
        if (this.loop) {
            // empty if block
        }
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || !this.field_145850_b.func_175640_z(this.field_174879_c)) {
            // empty if block
        }
    }

    private SoundEvent setSound(ResourceLocation resource) {
        return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)resource);
    }

    public void playSound(ResourceLocation resource, float volume, boolean looping) {
        this.loop = looping;
        this.shouldStart = true;
        this.setVolume(volume);
        this.soundEvent = this.setSound(resource);
    }

    public boolean shouldStop() {
        return this.shouldStart;
    }

    public void stop() {
        this.shouldStop = false;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void addPlayer(String name) {
        this.playerList.add(name);
    }

    public void removePlayer(String name) {
        this.playerList.remove(name);
    }

    public void onPlayerJoin() {
    }

    public void onPlayerLeave() {
    }

    public void onGameStart() {
    }

    public void onGameEnd() {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Game", this.game);
        compound.func_74768_a("Energy", this.storage.getEnergyStored());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.game = compound.func_74762_e("Game");
        this.storage.receiveEnergy(compound.func_74762_e("Energy"), false);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.handleUpdateTag(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        boolean meta = false;
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState old, IBlockState newState) {
        return world.func_175623_d(pos);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.storage;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

