/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import superhb.arcademod.api.gui.GuiArcade;
import superhb.arcademod.client.ArcadeItems;
import superhb.arcademod.client.audio.ArcadeSounds;
import superhb.arcademod.client.audio.LoopingSound;
import superhb.arcademod.client.tileentity.ArcadeLeaderboard;
import superhb.arcademod.client.tileentity.TileEntityArcade;
import superhb.arcademod.util.KeyHandler;

public class GuiSpaceInvaders
extends GuiArcade {
    private static final ResourceLocation texture = new ResourceLocation("arcademod:textures/gui/spaceinvaders.png");
    private static final int GUI_X = 234;
    private static final int GUI_Y = 284;
    private static final int MAZE_X = 224;
    private static final int MAZE_Y = 248;
    private static final int ALIEN = 14;
    private static final int TANK = 15;
    private float volume = 1.0f;
    private int boardX;
    private int boardY;
    private int score;
    private Tile[][] tiles = new Tile[31][28];
    private byte level;
    private boolean gameOver;
    private boolean mazeBlink;
    private boolean nextLevel;
    private int mazeBlinkTick = 0;
    private int mazeBlinks = 0;
    private boolean playing;
    private boolean updatePos;
    private boolean allDead;
    private int startTick = 0;
    private int bonusTick;
    private int bonusTime;
    private boolean showBonus;
    private int backTick;
    private int activeBombs;
    private int ufoScore = 0;
    LoopingSound theme;
    int topScore;
    String topName;
    ArcadeLeaderboard[] leaderboard = this.getTileEntity().getLeaderboard();
    private Player tank;
    private Alien[] aliens = new Alien[32];
    private Bullet bullet;
    private Bomb[] bombs = new Bomb[8];
    private UFO ufo;
    private Direction lastDirection;
    private Direction desiredDirection = Direction.LEFT;
    private int deathTick = 0;
    private int gameOverTick = 0;

    public GuiSpaceInvaders(World world, TileEntityArcade tile, @Nullable BlockPos pos, EntityPlayer player) {
        super(world, tile, pos, player);
        this.setGuiSize(234, 284, 0.8f);
        this.setTexture(texture, 512, 512);
        this.setCost(4);
        this.setOffset(0, 0);
        this.setButtonPos(117 - this.buttonWidth / 2, 254);
        this.setStartMenu(0);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.inMenu) {
            if (this.field_146297_k.func_147118_V().func_147692_c((ISound)this.theme)) {
                this.field_146297_k.func_147118_V().func_147683_b((ISound)this.theme);
            }
            if (this.menu == 3 && this.tickCounter - this.backTick == 60) {
                this.level = 0;
                this.gameOverTick = 0;
                this.deathTick = 0;
                this.mazeBlinkTick = 0;
                this.mazeBlinks = 0;
                this.score = 0;
                this.tickCounter = 0;
                this.checkMenuAfterGameOver();
            }
        } else if (this.playing) {
            int i;
            int i2;
            if (this.theme == null) {
                this.theme = new LoopingSound(this.getTileEntity(), ArcadeSounds.SPACEINVADERS, SoundCategory.RECORDS, this.volume - 0.5f);
            }
            if (!this.field_146297_k.func_147118_V().func_147692_c((ISound)this.theme)) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)this.theme);
            }
            for (i2 = 0; i2 < 3; ++i2) {
                this.tank.move().updatePosition(this.boardX, this.boardY);
            }
            this.tank.update();
            if (this.desiredDirection == Direction.DOWN) {
                for (i2 = 0; i2 < this.aliens.length; ++i2) {
                    if (!this.aliens[i2].isVisible) continue;
                    this.aliens[i2].ai().move().updatePosition(this.boardX, this.boardY);
                }
                if (this.lastDirection == Direction.LEFT) {
                    this.desiredDirection = Direction.RIGHT;
                    this.lastDirection = Direction.RIGHT;
                } else {
                    this.desiredDirection = Direction.LEFT;
                    this.lastDirection = Direction.LEFT;
                }
            } else {
                for (i2 = 0; i2 < this.aliens.length; ++i2) {
                    if (!this.aliens[i2].isVisible) continue;
                    this.aliens[i2].ai().move().updatePosition(this.boardX, this.boardY);
                }
            }
            for (i2 = 0; i2 < this.aliens.length; ++i2) {
                this.aliens[i2].current = this.desiredDirection;
                this.aliens[i2].update();
            }
            Random random = new Random();
            this.activeBombs = 0;
            for (i = 0; i < this.bombs.length; ++i) {
                if (!this.bombs[i].isVisible) continue;
                ++this.activeBombs;
            }
            block5: for (i = 0; i < this.level; ++i) {
                int id;
                if (this.activeBombs >= this.level || !this.aliens[id = random.nextInt(32)].isVisible) continue;
                for (int j = 0; j < this.bombs.length; ++j) {
                    if (this.bombs[j].isVisible) continue;
                    this.bombs[j] = new Bomb(j, this.aliens[id].x, this.aliens[id].y, this.aliens[id].aliencolor, true);
                    this.bombs[j].canMove = true;
                    ++this.activeBombs;
                    continue block5;
                }
            }
            if (this.bullet != null) {
                this.bullet.move().updatePosition(this.boardX, this.boardY);
            }
            for (i = 0; i < this.bombs.length; ++i) {
                if (!this.bombs[i].isVisible) continue;
                this.bombs[i].move().updatePosition(this.boardX, this.boardY);
                this.bombs[i].update();
            }
            if (this.score >= this.ufoScore + 100) {
                this.ufoScore = this.score;
                if (this.ufo == null) {
                    this.ufo = new UFO(0, 26, 4, new Color(100, random.nextInt(256), random.nextInt(256)), true);
                    this.ufo.canMove = true;
                }
            }
            if (this.ufo != null) {
                this.ufo.move().updatePosition(this.boardX, this.boardY);
                if (this.ufo != null) {
                    this.ufo.update();
                }
            }
            this.collisionDetection();
            this.allDead = true;
            for (i = 0; i < this.aliens.length; ++i) {
                if (!this.aliens[i].isVisible) continue;
                this.allDead = false;
            }
            if (this.allDead) {
                if (!this.nextLevel) {
                    this.tank.canMove = false;
                    for (i = 0; i < this.aliens.length; ++i) {
                        this.aliens[i].canMove = false;
                    }
                    this.nextLevel = true;
                    this.mazeBlinkTick = this.tickCounter;
                }
                if (this.tickCounter - this.mazeBlinkTick == 40 && this.mazeBlinks == 0 || this.tickCounter - this.mazeBlinkTick == 5 && this.mazeBlinks < 5) {
                    this.mazeBlinkTick = this.tickCounter;
                    this.mazeBlink = !this.mazeBlink;
                    ++this.mazeBlinks;
                }
                if (this.mazeBlinks == 5) {
                    this.level = (byte)(this.level + 1);
                    this.mazeBlink = false;
                    this.mazeBlinks = 0;
                    this.allDead = false;
                    this.gameOverTick = 0;
                    this.deathTick = 0;
                    this.tickCounter = 0;
                    this.setupTiles();
                    this.setupGame();
                }
            }
            if (this.showBonus && this.tickCounter - this.bonusTick == this.bonusTime) {
                this.showBonus = false;
            }
        } else {
            int i;
            if (this.tickCounter - this.startTick == 35) {
                this.playing = true;
                this.tank.canMove = true;
                for (i = 0; i < this.aliens.length; ++i) {
                    this.aliens[i].canMove = true;
                }
            }
            if (!this.updatePos) {
                this.updatePos = true;
                this.tank.updatePosition(this.boardX, this.boardY);
                for (i = 0; i < this.aliens.length; ++i) {
                    this.aliens[i].updatePosition(this.boardX, this.boardY);
                }
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.boardX = this.xScaled - 117 + 5;
        this.boardY = this.yScaled - 142 + 14;
        super.func_73863_a(mouseX, mouseY, partialTick);
        int controlWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]));
        int settingWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:setting.locale", (Object[])new Object[0]));
        if (this.inMenu) {
            switch (this.menu) {
                case 0: {
                    int titleWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"game.arcademod:spaceinvaders.name", (Object[])new Object[0]));
                    int startWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]));
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"game.arcademod:spaceinvaders.name", (Object[])new Object[0]), this.boardX + 117 - titleWidth / 2, this.boardY + 2, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]), this.boardX + 117 - startWidth / 2, this.boardY + 142 - 30, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]), this.boardX + 117 - controlWidth / 2, this.boardY + 142 - 20, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:setting.locale", (Object[])new Object[0]), this.boardX + 117 - settingWidth / 2, this.boardY + 142 - 10, Color.WHITE.getRGB());
                    if (this.menuOption == 0) {
                        this.drawRightArrow(this.boardX + 117 - 30, this.boardY + 142 - 32, true);
                        break;
                    }
                    if (this.menuOption == 1) {
                        this.drawRightArrow(this.boardX + 117 - 30, this.boardY + 142 - 22, true);
                        break;
                    }
                    if (this.menuOption != 2) break;
                    this.drawRightArrow(this.boardX + 117 - 30, this.boardY + 142 - 12, true);
                    break;
                }
                case 1: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]), this.boardX + 117 - controlWidth / 2, this.boardY + 2, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.up.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:up.spaceinvaders.name", (Object[])new Object[0]), this.boardX + 117 - 30, this.boardY + 142 - 20, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:left.name", (Object[])new Object[0]), this.boardX + 117 - 30, this.boardY + 142, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.right.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:right.name", (Object[])new Object[0]), this.boardX + 117 - 30, this.boardY + 142 + 10, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.boardX + 2, this.boardY + 284 - 30, Color.white.getRGB());
                    break;
                }
                case 2: {
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.boardX + 2, this.boardY + 284 - 30, Color.white.getRGB());
                    break;
                }
                case 3: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0]), this.boardX + 117 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0])) / 2, this.boardY + 142 - 20, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + ": " + this.score, this.boardX + 117 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:score.locale=Score", (Object[])new Object[0]) + ": " + this.score), this.boardY + 142, Color.WHITE.getRGB());
                }
            }
        } else {
            int i;
            this.drawMaze();
            for (int y = 0; y < 31; ++y) {
                for (int x = 0; x < 28; ++x) {
                    if (this.tiles[y][x] == null) continue;
                    this.tiles[y][x].updatePosition(this.boardX, this.boardY).drawTile();
                }
            }
            if (this.playing) {
                for (i = 0; i < this.aliens.length; ++i) {
                    if (!this.aliens[i].isVisible) continue;
                    this.aliens[i].drawAlien();
                }
            }
            this.tank.drawPlayer().drawLives();
            if (this.bullet != null) {
                this.bullet.drawBullet();
            }
            for (i = 0; i < this.bombs.length; ++i) {
                if (!this.bombs[i].isVisible) continue;
                this.bombs[i].drawBomb();
            }
            if (this.ufo != null) {
                this.ufo.drawUFO();
            }
            if (!this.playing) {
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:ready.spaceinvaders.locale", (Object[])new Object[0]), this.boardX + 112 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:ready.spaceinvaders.locale", (Object[])new Object[0])) / 2, this.boardY + 124 + 13, Color.yellow.getRGB());
            }
            this.field_146289_q.func_78276_b(String.format(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + " %d", this.score), this.boardX + 10, this.boardY + 6, Color.white.getRGB());
            this.field_146289_q.func_78276_b(String.format(I18n.func_135052_a((String)"text.arcademod:level.locale", (Object[])new Object[0]) + " %d", this.level), this.boardX + 170, this.boardY + 6, Color.white.getRGB());
        }
    }

    private void drawMaze() {
        if (this.mazeBlink) {
            this.glColor(Color.WHITE);
        } else {
            this.glColor(new Color(33, 33, 222));
        }
        GuiSpaceInvaders.func_146110_a((int)this.boardX, (int)this.boardY, (float)234.0f, (float)0.0f, (int)224, (int)248, (float)512.0f, (float)512.0f);
    }

    private void collisionDetection() {
        int i;
        for (i = 3; i >= 0; --i) {
            for (int j = 0; j < 8; ++j) {
                int id = i * 8 + j;
                if (this.bullet == null || this.bullet.extendedX < this.aliens[id].extendedX - 7 || this.bullet.extendedX > this.aliens[id].extendedX + 7 || this.bullet.extendedY < this.aliens[id].extendedY - 7 || this.bullet.extendedY > this.aliens[id].extendedY + 7 || !this.aliens[id].isVisible) continue;
                this.aliens[id].isVisible = false;
                this.bullet = null;
                this.score += 10;
                this.getWorld().func_184133_a(this.getPlayer(), this.getPos(), ArcadeSounds.SPACEINVADERS_DESTROYED, SoundCategory.BLOCKS, this.volume - 0.2f, 1.0f);
            }
        }
        for (i = 0; i < this.bombs.length; ++i) {
            if (!this.bombs[i].isVisible || this.bombs[i].extendedX < this.tank.extendedX - 7 || this.bombs[i].extendedX > this.tank.extendedX + 7 || this.bombs[i].extendedY + 7 < this.tank.extendedY - 7 || this.bombs[i].extendedY > this.tank.extendedY + 7) continue;
            this.endGame();
        }
        if (this.bullet != null && this.ufo != null && this.bullet.extendedX >= this.ufo.extendedX - 7 && this.bullet.extendedX <= this.ufo.extendedX + 7 && this.bullet.extendedY >= this.ufo.extendedY - 7 && this.bullet.extendedY <= this.ufo.extendedY + 7 && this.ufo.isVisible) {
            this.bullet = null;
            this.ufo = null;
            this.getWorld().func_184133_a(this.getPlayer(), this.getPos(), ArcadeSounds.SPACEINVADERS_DESTROYED, SoundCategory.BLOCKS, this.volume - 0.2f, 1.0f);
            this.score += 50;
        }
    }

    private void endGame() {
        if (!this.gameOver) {
            this.gameOver = true;
            this.tank.canMove = false;
            for (int i = 0; i < this.aliens.length; ++i) {
                this.aliens[i].canMove = false;
            }
            this.tank.kill();
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0]), this.boardX + 112 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0])) / 2, this.boardY + 124 + 13, Color.red.getRGB());
    }

    private void setupGame() {
        this.resetGame();
        if (this.gameOver) {
            this.tank.reset();
            this.gameOverTick = 0;
            this.deathTick = 0;
            this.tickCounter = 0;
            this.gameOver = false;
        }
        this.startTick = this.tickCounter;
        this.playing = false;
    }

    private void respawn() {
        if (this.gameOver) {
            this.tank.reset();
            this.gameOverTick = 0;
            this.deathTick = 0;
            this.tickCounter = 0;
            this.gameOver = false;
        }
        this.startTick = this.tickCounter;
        this.playing = false;
        this.activeBombs = 0;
    }

    private void resetGame() {
        int i;
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                int id = i * 8 + j;
                if (i == 0) {
                    this.aliens[id] = new Alien(id, 7 + j * 2, 5 + i * 2, new Color(29, 226, 255), true);
                }
                if (i == 1) {
                    this.aliens[id] = new Alien(id, 7 + j * 2, 5 + i * 2, new Color(30, 180, 50), true);
                }
                if (i == 2) {
                    this.aliens[id] = new Alien(id, 7 + j * 2, 5 + i * 2, new Color(255, 180, 0), true);
                }
                if (i != 3) continue;
                this.aliens[id] = new Alien(id, 7 + j * 2, 5 + i * 2, new Color(180, 30, 180), true);
            }
        }
        this.allDead = false;
        this.nextLevel = false;
        for (i = 0; i < this.bombs.length; ++i) {
            this.bombs[i] = new Bomb(i, 1, 1, new Color(0, 0, 0), false);
        }
        this.activeBombs = 0;
    }

    private void startGame() {
        this.score = 0;
        this.level = 1;
        this.inMenu = false;
        this.tank = new Player();
        this.canGetCoinBack = false;
        this.setupTiles();
        this.setupGame();
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.inMenu) {
            if (this.menu == 0) {
                if (keyCode == KeyHandler.down.func_151463_i()) {
                    this.menuOption = this.menuOption == 2 ? 0 : ++this.menuOption;
                }
                if (keyCode == KeyHandler.up.func_151463_i()) {
                    this.menuOption = this.menuOption == 0 ? 2 : --this.menuOption;
                }
                if (keyCode == KeyHandler.select.func_151463_i()) {
                    if (this.menuOption == 0) {
                        this.startGame();
                    } else {
                        this.menu = this.menuOption;
                    }
                }
            }
            if (keyCode == KeyHandler.left.func_151463_i()) {
                this.menu = 0;
            }
        } else {
            if (keyCode == KeyHandler.left.func_151463_i()) {
                this.tank.current = Direction.LEFT;
            } else if (keyCode == KeyHandler.right.func_151463_i()) {
                this.tank.current = Direction.RIGHT;
            } else if (keyCode == KeyHandler.up.func_151463_i() && this.bullet == null) {
                this.bullet = new Bullet(0, this.tank.x, this.tank.y, new Color(255, 0, 0), true);
                this.bullet.canMove = true;
                this.getWorld().func_184133_a(this.getPlayer(), this.getPos(), ArcadeSounds.SPACEINVADERS_SHOOT, SoundCategory.BLOCKS, this.volume, 1.0f);
            }
            if (keyCode == 1) {
                this.giveReward(ArcadeItems.TICKET, this.score / 200);
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void setupTiles() {
        int i;
        for (i = 0; i < 28; ++i) {
            this.tiles[0][i] = new Tile(i, 0, EnumTile.WALL);
        }
        for (int j = 1; j <= 29; ++j) {
            for (int i2 = 0; i2 < 28; ++i2) {
                this.tiles[j][i2] = i2 == 0 || i2 == 27 ? new Tile(i2, j, EnumTile.WALL) : new Tile(i2, j, EnumTile.PLAY);
            }
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[30][i] = new Tile(i, 30, EnumTile.WALL);
        }
    }

    private class Mover {
        Direction current;
        int x;
        int y;
        int x1;
        int y1;
        float moveX;
        float moveY;
        int extendedX;
        int extendedY;
        int offsetX;
        int offsetY;
        public boolean canMove;

        private Mover(int x, int y) {
            this.setStartPos(x, y);
        }

        public Mover updatePosition(int x, int y) {
            this.extendedX = (int)((float)(this.x1 + x) + this.moveX);
            this.extendedY = (int)((float)(this.y1 + y) + this.moveY);
            this.offsetX = x;
            this.offsetY = y;
            if ((this.extendedX - x) % 8 == 0) {
                this.x = (this.extendedX - x) / 8;
            }
            if ((this.extendedY - y) % 8 == 0) {
                this.y = (this.extendedY - y) / 8;
            }
            return this;
        }

        public void setStartPos(int x, int y) {
            this.x1 = x * 8 - 4;
            this.y1 = y * 8;
            this.x = x;
            this.y = y;
        }

        public boolean isBlocked() {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[Math.max((int)0, (int)(this.y - 1))][this.x].type == EnumTile.WALL;
        }

        public boolean isBlockedDown() {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[this.y + 1][this.x].type == EnumTile.WALL;
        }

        boolean isBlockedLeft() {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[this.y][Math.max((int)0, (int)(this.x - 1))].type == EnumTile.WALL;
        }

        boolean isBlockedRight() {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[this.y][Math.min((int)27, (int)(this.x + 1))].type == EnumTile.WALL;
        }

        public void update() {
        }
    }

    private class UFO
    extends Mover {
        int pauseTick;
        private int id;
        private Color color;
        private boolean isVisible;
        int BODY_STATE;

        public UFO(int id, int startx, int starty, Color color, boolean isVisible) {
            super(startx, starty);
            this.BODY_STATE = 0;
            this.id = id;
            this.color = color;
            this.isVisible = isVisible;
        }

        private Mover move() {
            if (this.canMove) {
                if (!this.isBlockedDown(this.x - 1, this.y)) {
                    if (this.isVisible) {
                        this.moveX -= this.getSpeed();
                    }
                } else {
                    this.canMove = false;
                    this.isVisible = false;
                    GuiSpaceInvaders.this.ufo = null;
                    return this;
                }
                return this;
            }
            return this;
        }

        private float getSpeed() {
            return 2.0f;
        }

        @Override
        public void update() {
            if ((this.extendedY - this.offsetY) % 4 == 0) {
                this.BODY_STATE = this.BODY_STATE == 0 ? 1 : 0;
            }
        }

        private boolean isBlockedDown(int x, int y) {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[Math.min((int)30, (int)(y + 1))][Math.max((int)0, (int)x)].type == EnumTile.WALL;
        }

        @Override
        public boolean isBlockedDown() {
            return this.isBlockedDown(this.x, this.y);
        }

        private UFO drawUFO() {
            if (!this.isVisible) {
                return this;
            }
            GuiSpaceInvaders.this.glColor(this.color);
            int startX = 356;
            if (this.BODY_STATE == 0) {
                Gui.func_146110_a((int)(this.extendedX - 3), (int)(this.extendedY - 3), (float)startX, (float)248.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
            } else {
                GuiSpaceInvaders.this.glColor(this.color.brighter());
                Gui.func_146110_a((int)(this.extendedX - 3), (int)(this.extendedY - 3), (float)startX, (float)248.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
            }
            return this;
        }
    }

    private class Bomb
    extends Mover {
        int pauseTick;
        private int id;
        private Color color;
        private boolean isVisible;
        int BODY_STATE;

        public Bomb(int id, int startx, int starty, Color color, boolean isVisible) {
            super(startx, starty);
            this.BODY_STATE = 0;
            this.id = id;
            this.color = color;
            this.isVisible = isVisible;
        }

        private Mover move() {
            if (this.canMove) {
                if (!this.isBlockedDown(this.x, this.y + 1)) {
                    if (this.isVisible) {
                        this.moveY += this.getSpeed();
                    }
                } else {
                    this.canMove = false;
                    this.isVisible = false;
                    return this;
                }
                return this;
            }
            return this;
        }

        private float getSpeed() {
            return 4.0f;
        }

        @Override
        public void update() {
            if ((this.extendedY - this.offsetY) % 4 == 0) {
                this.BODY_STATE = this.BODY_STATE == 0 ? 1 : 0;
            }
        }

        private boolean isBlockedDown(int x, int y) {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[Math.min((int)30, (int)(y + 1))][Math.max((int)0, (int)x)].type == EnumTile.WALL;
        }

        @Override
        public boolean isBlockedDown() {
            return this.isBlockedDown(this.x, this.y);
        }

        private Bomb drawBomb() {
            if (!this.isVisible) {
                return this;
            }
            GuiSpaceInvaders.this.glColor(this.color);
            if (this.BODY_STATE == 0) {
                Gui.func_146110_a((int)(this.extendedX - 3), (int)(this.extendedY - 3), (float)240.0f, (float)270.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
            } else {
                Gui.func_146110_a((int)(this.extendedX - 3), (int)(this.extendedY - 3), (float)257.0f, (float)270.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
            }
            return this;
        }
    }

    private class Bullet
    extends Mover {
        private int id;
        private Color color;
        private boolean isVisible;
        int BODY_STATE;

        public Bullet(int id, int startx, int starty, Color color, boolean isVisible) {
            super(startx, starty);
            this.BODY_STATE = 0;
            this.id = id;
            this.color = color;
            this.isVisible = isVisible;
        }

        private Mover move() {
            if (this.canMove) {
                if (!this.isBlocked(this.x, this.y - 4)) {
                    if (this.isVisible) {
                        this.moveY -= this.getSpeed();
                    }
                } else {
                    GuiSpaceInvaders.this.bullet = null;
                    return this;
                }
                return this;
            }
            return this;
        }

        private float getSpeed() {
            return 5.0f;
        }

        @Override
        public void update() {
            if ((this.extendedX - this.offsetX) % 4 == 0) {
                this.BODY_STATE = this.BODY_STATE == 0 ? 1 : 0;
            }
        }

        private boolean isBlocked(int x, int y) {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[Math.max((int)0, (int)(y - 1))][Math.max((int)0, (int)x)].type == EnumTile.WALL;
        }

        private boolean isBlockedDown(int x, int y) {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[Math.min((int)30, (int)(y + 1))][Math.max((int)0, (int)x)].type == EnumTile.WALL;
        }

        @Override
        public boolean isBlockedDown() {
            return this.isBlockedDown(this.x, this.y);
        }

        private Bullet drawBullet() {
            if (!this.isVisible) {
                return this;
            }
            GuiSpaceInvaders.this.glColor(this.color);
            Gui.func_146110_a((int)(this.extendedX - 3), (int)(this.extendedY - 3), (float)30.0f, (float)301.0f, (int)14, (int)4, (float)512.0f, (float)512.0f);
            return this;
        }
    }

    private class Alien
    extends Mover {
        private int alienid;
        private Color aliencolor;
        private boolean isVisible;
        int BODY_STATE;

        public Alien(int id, int startx, int starty, Color color, boolean isVisible) {
            super(startx, starty);
            this.BODY_STATE = 0;
            this.alienid = id;
            this.aliencolor = color;
            this.isVisible = isVisible;
            this.current = Direction.LEFT;
        }

        private Mover move() {
            if (this.canMove) {
                switch (this.current) {
                    case LEFT: {
                        if (!this.isBlockedLeft()) {
                            this.moveX -= this.getSpeed();
                        }
                        return this;
                    }
                    case RIGHT: {
                        if (!this.isBlockedRight()) {
                            this.moveX += this.getSpeed();
                        }
                        return this;
                    }
                    case UP: {
                        if (!this.isBlocked()) {
                            this.moveY -= this.getSpeed();
                        }
                        return this;
                    }
                    case DOWN: {
                        if (!this.isBlockedDown()) {
                            this.moveY += 3.0f;
                        }
                        return this;
                    }
                    case STAND: {
                        return this;
                    }
                }
            }
            return this;
        }

        private float getSpeed() {
            if (GuiSpaceInvaders.this.level == 1 || GuiSpaceInvaders.this.level == 2) {
                return 0.75f;
            }
            if (GuiSpaceInvaders.this.level == 3 || GuiSpaceInvaders.this.level == 4) {
                return 1.0f;
            }
            if (GuiSpaceInvaders.this.level >= 5) {
                return 2.0f;
            }
            return 0.75f;
        }

        @Override
        public void update() {
            if ((this.extendedX - this.offsetX) % 4 == 0) {
                this.BODY_STATE = this.BODY_STATE == 0 ? 1 : 0;
            }
        }

        private Alien ai() {
            if (this.current == Direction.LEFT && this.isBlockedLeft(this.x - 1, this.y)) {
                GuiSpaceInvaders.this.desiredDirection = Direction.DOWN;
            }
            if (this.current == Direction.RIGHT && this.isBlockedRight(this.x + 1, this.y)) {
                GuiSpaceInvaders.this.desiredDirection = Direction.DOWN;
            }
            if (this.current == Direction.DOWN && this.isBlockedDown(this.x, this.y + 2) && this.isVisible) {
                ((GuiSpaceInvaders)GuiSpaceInvaders.this).tank.lives = 0;
                GuiSpaceInvaders.this.endGame();
            }
            return this;
        }

        private boolean isBlockedDown(int x, int y) {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[Math.min((int)30, (int)(y + 1))][Math.max((int)0, (int)x)].type == EnumTile.WALL;
        }

        private boolean isBlockedLeft(int x, int y) {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[y][Math.max((int)0, (int)(x - 1))].type == EnumTile.WALL;
        }

        private boolean isBlockedRight(int x, int y) {
            return ((GuiSpaceInvaders)GuiSpaceInvaders.this).tiles[y][Math.min((int)27, (int)(x + 1))].type == EnumTile.WALL;
        }

        @Override
        public boolean isBlockedDown() {
            return this.isBlockedDown(this.x, this.y);
        }

        private Alien drawAlien() {
            if (!this.isVisible) {
                return this;
            }
            GuiSpaceInvaders.this.glColor(this.aliencolor);
            int startX = 244;
            if (this.alienid < 32) {
                startX = 244;
            }
            if (this.alienid < 24) {
                startX = 328;
            }
            if (this.alienid < 16) {
                startX = 300;
            }
            if (this.alienid < 8) {
                startX = 272;
            }
            if (this.BODY_STATE == 0) {
                Gui.func_146110_a((int)(this.extendedX - 3), (int)(this.extendedY - 3), (float)startX, (float)248.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
            } else {
                Gui.func_146110_a((int)(this.extendedX - 3), (int)(this.extendedY - 3), (float)(startX + 14), (float)248.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
            }
            return this;
        }
    }

    private class Player
    extends Mover {
        int lives;
        int deathAnimation;
        boolean playDeathAnimation;
        int STATE;
        int prevX;
        int prevY;

        public Player() {
            super(14, 29);
            this.lives = 3;
            this.STATE = 0;
            this.prevX = 14;
            this.prevY = 29;
            this.current = Direction.LEFT;
        }

        private Mover move() {
            if (this.canMove) {
                switch (this.current) {
                    case LEFT: {
                        if (!this.isBlockedLeft()) {
                            if (GuiSpaceInvaders.this.isKeyDown(KeyHandler.left.func_151463_i())) {
                                this.moveX -= this.getSpeed();
                            }
                        } else {
                            this.current = Direction.STAND;
                        }
                        return this;
                    }
                    case RIGHT: {
                        if (!this.isBlockedRight()) {
                            if (GuiSpaceInvaders.this.isKeyDown(KeyHandler.right.func_151463_i())) {
                                this.moveX += this.getSpeed();
                            }
                        } else {
                            this.current = Direction.STAND;
                        }
                        return this;
                    }
                    case UP: {
                        return this;
                    }
                    case DOWN: {
                        return this;
                    }
                    case STAND: {
                        return this;
                    }
                }
            }
            return this;
        }

        @Override
        public void update() {
            if (this.playDeathAnimation) {
                if (this.deathAnimation <= 12 && GuiSpaceInvaders.this.tickCounter - GuiSpaceInvaders.this.deathTick == 2) {
                    GuiSpaceInvaders.this.deathTick = GuiSpaceInvaders.this.tickCounter;
                    ++this.deathAnimation;
                }
                if (this.deathAnimation >= 12 && GuiSpaceInvaders.this.gameOverTick == 0) {
                    this.moveY = 0.0f;
                    this.moveX = 0.0f;
                    this.setStartPos(14, 29);
                    this.prevX = 14;
                    this.prevY = 29;
                    GuiSpaceInvaders.this.gameOverTick = GuiSpaceInvaders.this.tickCounter;
                }
                if (GuiSpaceInvaders.this.tickCounter - GuiSpaceInvaders.this.gameOverTick == 20) {
                    if (this.lives == 0) {
                        GuiSpaceInvaders.this.giveReward(ArcadeItems.TICKET, GuiSpaceInvaders.this.score / 200);
                        GuiSpaceInvaders.this.inMenu = true;
                        GuiSpaceInvaders.this.menu = 3;
                        this.playDeathAnimation = false;
                        GuiSpaceInvaders.this.backTick = GuiSpaceInvaders.this.tickCounter;
                        GuiSpaceInvaders.this.gameOver = (GuiSpaceInvaders.this.mazeBlink = (GuiSpaceInvaders.this.nextLevel = (GuiSpaceInvaders.this.updatePos = false)));
                    } else {
                        --this.lives;
                        GuiSpaceInvaders.this.respawn();
                        this.deathAnimation = 0;
                        this.playDeathAnimation = false;
                        GuiSpaceInvaders.this.showBonus = false;
                        GuiSpaceInvaders.this.bonusTick = 0;
                    }
                }
            }
        }

        public void kill() {
            this.playDeathAnimation = true;
            GuiSpaceInvaders.this.deathTick = GuiSpaceInvaders.this.tickCounter;
            GuiSpaceInvaders.this.getWorld().func_184133_a(GuiSpaceInvaders.this.getPlayer(), GuiSpaceInvaders.this.getPos(), ArcadeSounds.SPACEINVADERS_EXPLODE, SoundCategory.BLOCKS, GuiSpaceInvaders.this.volume, 1.0f);
        }

        private void reset() {
            this.setStartPos(14, 29);
            this.prevX = 14;
            this.prevY = 29;
            this.moveY = 0.0f;
            this.moveX = 0.0f;
            this.current = Direction.LEFT;
        }

        private float getSpeed() {
            if (GuiSpaceInvaders.this.level == 0) {
                return 0.8f;
            }
            if (GuiSpaceInvaders.this.level >= 1 && GuiSpaceInvaders.this.level <= 3) {
                return 0.9f;
            }
            if (GuiSpaceInvaders.this.level >= 4 && GuiSpaceInvaders.this.level <= 19) {
                return 1.0f;
            }
            if (GuiSpaceInvaders.this.level >= 20) {
                return 0.9f;
            }
            return 0.8f;
        }

        @Override
        public Player updatePosition(int x, int y) {
            super.updatePosition(x, y);
            if (this.x != this.prevX || this.y != this.prevY) {
                this.prevX = this.x;
                this.prevY = this.y;
                this.STATE = this.STATE == 0 ? 1 : 0;
            }
            return this;
        }

        private Player drawPlayer() {
            if (!GuiSpaceInvaders.this.gameOver) {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                switch (this.current) {
                    case STAND: {
                        Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)0.0f, (float)300.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                        return this;
                    }
                    case LEFT: {
                        Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)0.0f, (float)300.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                        return this;
                    }
                    case RIGHT: {
                        Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)0.0f, (float)300.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                        return this;
                    }
                    case DOWN: {
                        return this;
                    }
                    case UP: {
                        Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)0.0f, (float)300.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                        return this;
                    }
                }
            } else {
                GuiSpaceInvaders.this.glColor(Color.WHITE);
                if (this.playDeathAnimation && this.deathAnimation <= 12) {
                    Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)(15 * this.deathAnimation), (float)330.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                }
            }
            return this;
        }

        private Player drawLives() {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < this.lives; ++i) {
                Gui.func_146110_a((int)(this.offsetX + i * 14), (int)(this.offsetY + 248), (float)0.0f, (float)300.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
            }
            return this;
        }
    }

    private class Tile {
        int x;
        int y;
        int extendedX;
        int extendedY;
        int edible = 0;
        EnumTile type;

        Tile(int x, int y, EnumTile type) {
            this(x, y, type, 0);
        }

        Tile(int x, int y, EnumTile type, int edible) {
            this.x = x;
            this.y = y;
            this.extendedX = x * 8 + GuiSpaceInvaders.this.boardX;
            this.extendedY = y * 8 + GuiSpaceInvaders.this.boardY;
            this.type = type;
            this.edible = edible;
        }

        Tile drawTile() {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            return this;
        }

        Tile updatePosition(int x, int y) {
            this.extendedX = this.x * 8 + x;
            this.extendedY = this.y * 8 + y;
            return this;
        }
    }

    private static enum EnumTile {
        PLAY(0, Color.GREEN),
        WALL(1, Color.RED),
        TELE(2, Color.YELLOW),
        TELE_ZONE(3, Color.ORANGE),
        GHOST_ONLY(4, Color.WHITE),
        GHOST_LIMIT(5, Color.MAGENTA);

        private int id;
        private Color color;

        private EnumTile(int id, Color color) {
            this.id = id;
            this.color = color;
        }
    }

    private static enum Direction {
        STAND(0, 0, 0),
        UP(1, 2, 1),
        DOWN(2, 1, 1),
        LEFT(3, 4, 2),
        RIGHT(4, 3, 2);

        private int direction;
        private int opposite;

        private Direction(int direction, int opposite, int axis) {
            this.direction = direction;
            this.opposite = opposite;
        }
    }
}

