/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.gui;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import superhb.arcademod.api.gui.GuiArcade;
import superhb.arcademod.client.ArcadeItems;
import superhb.arcademod.client.tileentity.TileEntityArcade;
import superhb.arcademod.network.pong.GetPlayerMessage;
import superhb.arcademod.util.ArcadePacketHandler;
import superhb.arcademod.util.KeyHandler;

public class GuiPong
extends GuiArcade {
    private static final ResourceLocation texture = new ResourceLocation("arcademod:textures/gui/pong.png");
    private static final int BOARD_X = 240;
    private static final int BOARD_Y = 154;
    private static final int GUI_X = 252;
    private static final int GUI_Y = 166;
    private static final int PADDLE_X = 5;
    private static final int PADDLE_Y = 28;
    private static final int OUTLINE_X = 236;
    private static final int OUTLINE_Y = 150;
    private static final int BALL = 4;
    private static final int NUMBER_X = 12;
    private static final int NUMBER_Y = 20;
    private static final int WINNER_X = 86;
    private static final int WINNER_Y = 17;
    private static final int LOSER_X = 65;
    private static final int LOSER_Y = 17;
    private int boardX;
    private int boardY;
    private int mouseY;
    private Rectangle[] outlineBoundingBox = new Rectangle[2];
    private Rectangle[] outBoundingBox = new Rectangle[2];
    private boolean canMultiplayer;
    private boolean isPlayingMultiplayer;
    private boolean inMultiplayerMenu;
    private boolean canStartMultiplayer;
    private int startOption;
    private int endGame;
    private Ball ball;
    private Paddle[] paddles = new Paddle[2];
    private EntityPlayer opponent;

    public GuiPong(World world, TileEntityArcade tileEntity, @Nullable BlockPos pos, EntityPlayer player) {
        super(world, tileEntity, pos, player);
        this.func_183500_a(252, 166);
        this.setCost(1);
        this.setOffset(0, 0);
        this.setButtonPos(126 - this.buttonWidth / 2, 136);
        this.setTexture(texture, 512, 512);
        this.setStartMenu(0);
        this.addPlayer(player.func_70005_c_());
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (!this.inMenu && this.endGame == 0) {
            int i;
            for (i = 0; i < 3; ++i) {
                this.outlineBoundingBox[0].setLocation(this.boardX, this.boardY);
                this.outlineBoundingBox[1].setLocation(this.boardX, this.boardY + 145);
                this.outBoundingBox[0].setLocation(this.boardX - 5, this.boardY + 5);
                this.outBoundingBox[1].setLocation(this.boardX + 236, this.boardY + 5);
                this.paddles[0].updatePosition(this.boardX, this.boardY);
                this.paddles[0].ai();
                this.paddles[1].updatePosition(this.boardX, this.boardY, this.mouseY);
                this.ball.updatePosition(this.boardX, this.boardY);
            }
            for (i = 0; i < 3; ++i) {
                this.ball.collisionDetection();
            }
            this.ball.updateAngle();
            if (this.paddles[0].score / 3 == 10) {
                this.endGame = 1;
            } else if (this.paddles[1].score / 3 == 10) {
                this.endGame = 2;
                this.giveReward(ArcadeItems.TICKET, 10);
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.boardX = this.xScaled - 126 + 8;
        this.boardY = this.yScaled - 83 + 8;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.inMenu) {
            if (Mouse.isGrabbed()) {
                Mouse.setGrabbed((boolean)false);
            }
            switch (this.menu) {
                case 0: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"game.arcademod:pong.name", (Object[])new Object[0]), this.boardX + 126 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"game.arcademod:pong.name", (Object[])new Object[0])) / 2, this.boardY + 2, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]), this.boardX + 126 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0])) / 2, this.boardY + 83 - 10, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]), this.boardX + 126 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0])) / 2, this.boardY + 83, Color.WHITE.getRGB());
                    if (this.menuOption == 0) {
                        this.drawRightArrow(this.boardX + 126 - 30, this.boardY + 83 - 12, true);
                        break;
                    }
                    this.drawRightArrow(this.boardX + 126 - 30, this.boardY + 83 - 2, true);
                    break;
                }
                case 1: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]), this.boardX + 126 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0])) / 2, this.boardY + 2, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:singleplayer.name", (Object[])new Object[0]), this.boardX + 126 - 30, this.boardY + 83 - 10, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:multiplayer.name", (Object[])new Object[0]), this.boardX + 126 - 30, this.boardY + 83, Color.WHITE.getRGB());
                    if (this.startOption == 0) {
                        this.drawRightArrow(this.boardX + 126 - 40, this.boardY + 83 - 12, true);
                    } else {
                        this.drawRightArrow(this.boardX + 126 - 40, this.boardY + 83 - 2, true);
                    }
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.boardX + 2, this.boardY + 166 - 23, Color.WHITE.getRGB());
                    break;
                }
                case 2: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"control.arcademod:mouse.pong.name", (Object[])new Object[0]), this.boardX + this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"control.arcademod:mouse.pong.name", (Object[])new Object[0])) / 2, this.boardY + 83, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.boardX + 2, this.boardY + 166 - 23, Color.WHITE.getRGB());
                    break;
                }
                case 3: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:multiplayer.name", (Object[])new Object[0]), this.boardX + 126 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:multiplayer.name", (Object[])new Object[0])) / 2, this.boardY + 2, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + I18n.func_135052_a((String)"text.arcademod:left_paddle.pong.name", (Object[])new Object[0]) + "]", this.boardX + 126 - 70, this.boardY + 83 - 10, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + I18n.func_135052_a((String)"text.arcademod:right_paddle.pong.name", (Object[])new Object[0]) + "]", this.boardX + 126 - 70, this.boardY + 83, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.select.getDisplayName() + "]" + I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]), this.boardX + 2, this.boardY + 166 - 33, this.canStartMultiplayer ? Color.WHITE.getRGB() : Color.GRAY.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.boardX + 2, this.boardY + 166 - 23, Color.WHITE.getRGB());
                }
            }
        } else {
            Mouse.setGrabbed((boolean)true);
            GuiPong.func_146110_a((int)this.boardX, (int)this.boardY, (float)252.0f, (float)0.0f, (int)236, (int)150, (float)512.0f, (float)512.0f);
            this.drawScore();
            this.ball.draw();
            this.mouseY = mouseY <= this.boardY + 5 ? this.boardY + 5 : (mouseY >= this.boardY + 117 ? this.boardY + 117 : mouseY);
            for (Paddle paddle : this.paddles) {
                paddle.draw();
            }
            if (this.endGame > 0) {
                if (this.endGame == 2) {
                    GuiPong.func_146110_a((int)(this.boardX + 10), (int)(this.boardY + 30), (float)0.0f, (float)214.0f, (int)86, (int)17, (float)512.0f, (float)512.0f);
                } else if (this.endGame == 1) {
                    GuiPong.func_146110_a((int)(this.boardX + 10), (int)(this.boardY + 30), (float)0.0f, (float)231.0f, (int)65, (int)17, (float)512.0f, (float)512.0f);
                }
                this.field_146289_q.func_78276_b("[" + KeyHandler.select.getDisplayName() + "]", this.boardX + 2, this.boardY + 166 - 40, Color.WHITE.getRGB());
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:return_menu.name", (Object[])new Object[0]), this.boardX + 2, this.boardY + 166 - 30, Color.WHITE.getRGB());
            }
        }
    }

    private void drawScore() {
        this.glColor(Color.GRAY);
        if (this.paddles[0].score / 3 < 10) {
            GuiPong.func_146110_a((int)(this.boardX + 120 - 30), (int)(this.boardY + 7), (float)(12 * (this.paddles[0].score / 3)), (float)194.0f, (int)12, (int)20, (float)512.0f, (float)512.0f);
        } else {
            GuiPong.func_146110_a((int)(this.boardX + 120 - 30), (int)(this.boardY + 7), (float)0.0f, (float)194.0f, (int)12, (int)20, (float)512.0f, (float)512.0f);
            GuiPong.func_146110_a((int)(this.boardX + 120 - 40), (int)(this.boardY + 7), (float)12.0f, (float)194.0f, (int)12, (int)20, (float)512.0f, (float)512.0f);
        }
        if (this.paddles[1].score / 3 < 10) {
            GuiPong.func_146110_a((int)(this.boardX + 120 + 14), (int)(this.boardY + 7), (float)(12 * (this.paddles[1].score / 3)), (float)194.0f, (int)12, (int)20, (float)512.0f, (float)512.0f);
        } else {
            GuiPong.func_146110_a((int)(this.boardX + 120 + 28), (int)(this.boardY + 7), (float)0.0f, (float)194.0f, (int)12, (int)20, (float)512.0f, (float)512.0f);
            GuiPong.func_146110_a((int)(this.boardX + 120 + 14), (int)(this.boardY + 7), (float)12.0f, (float)194.0f, (int)12, (int)20, (float)512.0f, (float)512.0f);
        }
    }

    private void startGame() {
        this.inMenu = false;
        this.outlineBoundingBox[0] = new Rectangle(this.boardX, this.boardY, 236, 5);
        this.outlineBoundingBox[1] = new Rectangle(this.boardX, this.boardY + 145, 236, 5);
        this.outBoundingBox[0] = new Rectangle(this.boardX - 5, this.boardY + 5, 5, 140);
        this.outBoundingBox[1] = new Rectangle(this.boardX + 236, this.boardY + 5, 5, 140);
        this.paddles[0] = new Paddle(0, 5);
        this.paddles[1] = new Paddle(231, this.mouseY);
        this.ball = new Ball(116, (int)this.rand(5, 117), (int)this.rand(0, 2));
        this.canGetCoinBack = false;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.inMenu) {
            if (this.menu == 0) {
                if (keyCode == KeyHandler.up.func_151463_i()) {
                    this.menuOption = this.menuOption == 0 ? 1 : --this.menuOption;
                }
                if (keyCode == KeyHandler.down.func_151463_i()) {
                    this.menuOption = this.menuOption == 1 ? 0 : ++this.menuOption;
                }
                if (keyCode == KeyHandler.select.func_151463_i()) {
                    if (this.menuOption == 0) {
                        if (this.canMultiplayer) {
                            this.menu = 1;
                        } else {
                            this.startGame();
                        }
                    }
                    if (this.menuOption == 1) {
                        this.menu = 2;
                    }
                }
            } else if (this.menu == 1) {
                if (keyCode == KeyHandler.up.func_151463_i()) {
                    this.startOption = this.startOption == 0 ? 1 : --this.startOption;
                }
                if (keyCode == KeyHandler.down.func_151463_i()) {
                    this.startOption = this.startOption == 1 ? 0 : ++this.startOption;
                }
                if (keyCode == KeyHandler.select.func_151463_i()) {
                    if (this.startOption == 0) {
                        this.startGame();
                    } else {
                        this.menu = 3;
                    }
                }
                if (keyCode == KeyHandler.left.func_151463_i()) {
                    this.menu = 0;
                }
            } else if (this.menu == 2) {
                if (keyCode == KeyHandler.left.func_151463_i()) {
                    this.menu = 0;
                }
            } else if (this.menu == 3) {
                if (keyCode == KeyHandler.select.func_151463_i()) {
                    // empty if block
                }
                if (keyCode == KeyHandler.left.func_151463_i()) {
                    this.menu = 1;
                }
            }
        } else if (this.endGame > 0) {
            if (keyCode == KeyHandler.select.func_151463_i()) {
                this.inMenu = true;
                this.checkMenuAfterGameOver();
                this.endGame = 0;
            }
        } else if (keyCode == 1 && this.paddles[1].score > this.paddles[0].score) {
            this.giveReward(ArcadeItems.TICKET, this.paddles[1].score / 3);
        }
        if (keyCode == 1) {
            this.removePlayer(this.getPlayer().func_70005_c_());
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void addPlayer(String name) {
        this.getTileEntity().addPlayer(name);
    }

    public void removePlayer(String name) {
        this.getTileEntity().removePlayer(name);
    }

    public void joinGame() {
        ArcadePacketHandler.INSTANCE.sendToAllAround((IMessage)new GetPlayerMessage(), new NetworkRegistry.TargetPoint(0, (double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), 15.0));
    }

    private class Ball {
        int x;
        int y;
        int extendedX;
        int extendedY;
        int xV = 1;
        int yV = 1;
        int angle;
        int xA = 3;
        int yA = 3;
        Rectangle boundingBox;

        private Ball(int x, int y, int angle) {
            this.x = x;
            this.y = y;
            this.angle = angle;
            this.boundingBox = new Rectangle(x, y, 4, 4);
        }

        public void draw() {
            GuiPong.this.glColor(Color.WHITE);
            Gui.func_146110_a((int)this.extendedX, (int)this.extendedY, (float)5.0f, (float)166.0f, (int)4, (int)4, (float)512.0f, (float)512.0f);
        }

        public void updatePosition(int x, int y) {
            this.extendedX = x + this.x;
            this.extendedY = y + this.y;
            this.boundingBox.setLocation(this.extendedX, this.extendedY);
        }

        public void updateAngle() {
            int i;
            for (i = 0; i < this.xA; ++i) {
                this.x += this.xV;
            }
            for (i = 0; i < this.yA; ++i) {
                this.y += this.yV;
            }
        }

        public void collisionDetection() {
            for (Rectangle box : GuiPong.this.outlineBoundingBox) {
                if (!this.boundingBox.intersects(box)) continue;
                this.yV = -this.yV;
            }
            if (this.boundingBox.intersects(GuiPong.this.outBoundingBox[0])) {
                this.xV = 1;
                this.angle = (int)GuiPong.this.rand(0, 2);
                this.x = 116;
                this.y = (int)GuiPong.this.rand(5, 117);
                ++((GuiPong)GuiPong.this).paddles[1].score;
            } else if (this.boundingBox.intersects(GuiPong.this.outBoundingBox[1])) {
                this.xV = -1;
                this.angle = (int)GuiPong.this.rand(0, 2);
                this.x = 116;
                this.y = (int)GuiPong.this.rand(5, 117);
                ++((GuiPong)GuiPong.this).paddles[0].score;
            }
            for (Paddle paddle : GuiPong.this.paddles) {
                if (!this.boundingBox.intersects(paddle.boundingBox)) continue;
                this.xV = -this.xV;
                int intersection = paddle.extendedY + 28 - this.extendedY;
                if (intersection > 14) {
                    if (intersection > 23) {
                        this.angle = 1;
                        continue;
                    }
                    if (intersection < 19) {
                        this.angle = 2;
                        continue;
                    }
                    this.yA = 3;
                    this.xA = 3;
                    continue;
                }
                if (intersection >= 14) continue;
                this.angle = intersection > 9 ? 2 : (intersection < 5 ? 1 : 0);
            }
            this.calculateAngle();
        }

        public void calculateAngle() {
            switch (this.angle) {
                case 0: {
                    this.yA = 3;
                    this.xA = 3;
                }
                case 1: {
                    this.yA = 3;
                    this.xA = 6;
                    break;
                }
                case 2: {
                    this.xA = 3;
                    this.yA = 6;
                }
            }
        }
    }

    private class Paddle {
        int x;
        int y;
        int extendedX;
        int extendedY;
        Rectangle boundingBox;
        int score = 0;

        private Paddle(int x, int y) {
            this.x = x;
            this.y = y;
            this.boundingBox = new Rectangle(x, y, 5, 28);
        }

        public void updatePosition(int x, int y) {
            this.extendedX = x + this.x;
            this.extendedY = y + this.y;
            this.boundingBox.setLocation(this.extendedX, this.extendedY);
        }

        public void updatePosition(int x, int y, int mouseY) {
            this.extendedX = x + this.x;
            this.extendedY = mouseY;
            this.boundingBox.setLocation(this.extendedX, this.extendedY);
        }

        public void ai() {
            if (this.extendedY > ((GuiPong)GuiPong.this).ball.extendedY && this.y != 5) {
                --this.y;
            } else if (this.extendedY < ((GuiPong)GuiPong.this).ball.extendedY && this.y != 117) {
                ++this.y;
            }
        }

        public void draw() {
            Gui.func_146110_a((int)this.extendedX, (int)this.extendedY, (float)0.0f, (float)166.0f, (int)5, (int)28, (float)512.0f, (float)512.0f);
        }
    }
}

