/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.util;

import com.mrcrayfish.furniture.gui.inventory.ISimpleInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class InventoryUtil {
    public static void dropTileEntityInventoryItems(World world, BlockPos pos, TileEntity te) {
        if (te instanceof ISimpleInventory) {
            InventoryUtil.dropInventoryItems(world, pos, (ISimpleInventory)te);
        }
        if (te instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)te));
        }
    }

    public static void dropInventoryItems(World world, BlockPos pos, ISimpleInventory inv) {
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack == null || stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
    }

    public static int calculateTileEntityRedstone(IItemHandler inventory) {
        if (inventory == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            ItemStack itemstack = inventory.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(inventory.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inventory.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static NBTTagList writeInventoryToNBT(ISimpleInventory inventory, NBTTagList nbt) {
        if (nbt != null) {
            for (int i = 0; i < inventory.getSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (stack == null || stack.func_190926_b()) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(itemTag);
                nbt.func_74742_a((NBTBase)itemTag);
            }
        }
        return nbt;
    }

    public static ItemStack[] readInventoryFromNBT(ISimpleInventory inventory, NBTTagList nbt) {
        ItemStack[] items = new ItemStack[inventory.getSize()];
        if (nbt != null) {
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                NBTTagCompound itemTag = nbt.func_150305_b(i);
                byte slot = itemTag.func_74771_c("Slot");
                if (slot < 0 || slot >= items.length) continue;
                items[slot] = new ItemStack(itemTag);
            }
        }
        return items;
    }
}

