/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.handler;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.client.category.AbstractCategory;
import com.mrcrayfish.furniture.client.category.Categories;
import com.mrcrayfish.furniture.init.FurnitureTab;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiDrawHandler {
    private static final ResourceLocation ICONS = new ResourceLocation("cfm:textures/gui/icons.png");
    private static final ResourceLocation BEACON = new ResourceLocation("textures/gui/container/beacon.png");
    private GuiLinkImageButton buttonWebsite;
    private GuiLinkImageButton buttonYouTube;
    private GuiLinkImageButton buttonTwitter;
    private GuiLinkImageButton buttonPatreon;
    private AbstractCategory[] categories;
    private List<GuiCategoryButton> categoryButtons;
    private GuiButton categoryUp;
    private GuiButton categoryDown;
    private GuiButton categoryEnableAll;
    private GuiButton categoryDisableAll;
    private static int startIndex;
    private List<GuiButton> buttonList;
    private boolean viewingFurnitureTab;
    private int guiCenterX = 0;
    private int guiCenterY = 0;

    @SubscribeEvent
    public void onDrawGui(GuiScreenEvent.InitGuiEvent.Post event) {
        this.viewingFurnitureTab = false;
        if (event.getGui() instanceof GuiContainerCreative) {
            this.guiCenterX = ((GuiContainerCreative)event.getGui()).getGuiLeft();
            this.guiCenterY = ((GuiContainerCreative)event.getGui()).getGuiTop();
            this.categories = new AbstractCategory[]{Categories.GENERAL, Categories.BEDROOM, Categories.KITCHEN, Categories.BATHROOM, Categories.OUTDOOR, Categories.ELECTRONICS, Categories.EVENT, Categories.STORAGE, Categories.LIGHTING, Categories.ITEMS};
            this.categoryButtons = Lists.newArrayList();
            this.buttonList = event.getButtonList();
            this.buttonWebsite = new GuiLinkImageButton(10, this.guiCenterX - 50, this.guiCenterY, ICONS, 48, 0, "https://mrcrayfish.com", TextFormatting.WHITE + "> " + TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"cfm.button.website", (Object[])new Object[0]));
            event.getButtonList().add(this.buttonWebsite);
            this.buttonYouTube = new GuiLinkImageButton(10, this.guiCenterX - 50, this.guiCenterY + 22, ICONS, 32, 0, "https://www.youtube.com/channel/UCSwwxl2lWJcbGOGQ_d04v2Q", TextFormatting.WHITE + "> " + TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"cfm.button.youtube", (Object[])new Object[0]));
            event.getButtonList().add(this.buttonYouTube);
            this.buttonTwitter = new GuiLinkImageButton(10, this.guiCenterX - 50, this.guiCenterY + 44, ICONS, 16, 0, "https://twitter.com/MrCraayfish", TextFormatting.WHITE + "> " + TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"cfm.button.twitter", (Object[])new Object[0]));
            event.getButtonList().add(this.buttonTwitter);
            this.buttonPatreon = new GuiLinkImageButton(10, this.guiCenterX - 50, this.guiCenterY, ICONS, 0, 0, "https://www.patreon.com/mrcrayfish", TextFormatting.WHITE + "> " + TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"cfm.button.patreon", (Object[])new Object[0]));
            event.getButtonList().add(this.buttonPatreon);
            this.categoryUp = new GuiArrowButton(11, this.guiCenterX - 22, this.guiCenterY - 12, 20, 20, true);
            event.getButtonList().add(this.categoryUp);
            this.categoryDown = new GuiArrowButton(11, this.guiCenterX - 22, this.guiCenterY + 127, 20, 20, false);
            event.getButtonList().add(this.categoryDown);
            this.categoryEnableAll = new GuiImageButton(this.guiCenterX - 50, this.guiCenterY + 88, 91, 223, 14, 14, BEACON);
            event.getButtonList().add(this.categoryEnableAll);
            this.categoryDisableAll = new GuiImageButton(this.guiCenterX - 50, this.guiCenterY + 110, 114, 223, 14, 14, BEACON);
            event.getButtonList().add(this.categoryDisableAll);
            this.updateCategories();
            GuiContainerCreative creative = (GuiContainerCreative)event.getGui();
            if (creative.func_147056_g() == MrCrayfishFurnitureMod.tabFurniture.func_78021_a()) {
                this.viewingFurnitureTab = true;
                this.categoryButtons.forEach(guiCategoryButton -> {
                    guiCategoryButton.field_146125_m = true;
                });
                this.updateItems(creative);
            }
        }
    }

    private void updateCategories() {
        if (!this.categoryButtons.isEmpty()) {
            this.buttonList.removeAll(this.categoryButtons);
            this.categoryButtons.clear();
        }
        for (int i = startIndex; i < startIndex + 4 && i < this.categories.length; ++i) {
            GuiCategoryButton button = new GuiCategoryButton(this.guiCenterX - 28, this.guiCenterY + 29 * (i - startIndex) + 10, this.categories[i]);
            this.categoryButtons.add(button);
            this.buttonList.add(button);
        }
        this.updateCategoryButtons();
    }

    @SubscribeEvent
    public void onDrawGui(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            GuiContainerCreative creative = (GuiContainerCreative)event.getGui();
            if (creative.func_147056_g() == MrCrayfishFurnitureMod.tabFurniture.func_78021_a()) {
                if (!this.viewingFurnitureTab) {
                    this.updateItems(creative);
                    this.viewingFurnitureTab = true;
                }
            } else {
                this.viewingFurnitureTab = false;
            }
        }
    }

    @SubscribeEvent
    public void onDrawGui(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            GuiContainerCreative creative = (GuiContainerCreative)event.getGui();
            this.guiCenterX = creative.getGuiLeft();
            this.guiCenterY = creative.getGuiTop();
            if (creative.func_147056_g() == MrCrayfishFurnitureMod.tabFurniture.func_78021_a()) {
                this.buttonWebsite.field_146125_m = true;
                this.buttonYouTube.field_146125_m = true;
                this.buttonTwitter.field_146125_m = true;
                this.buttonPatreon.field_146125_m = true;
                this.categoryUp.field_146125_m = true;
                this.categoryDown.field_146125_m = true;
                this.categoryEnableAll.field_146125_m = true;
                this.categoryDisableAll.field_146125_m = true;
                this.categoryButtons.forEach(guiButton -> {
                    guiButton.field_146125_m = true;
                });
                this.categoryButtons.forEach(guiButton -> {
                    if (guiButton.func_146115_a()) {
                        guiButton.drawHoveringText(event.getGui(), event.getMouseX(), event.getMouseY());
                    }
                });
                if (this.categoryEnableAll.func_146115_a()) {
                    event.getGui().func_146279_a("Enable All Filters", event.getMouseX(), event.getMouseY());
                } else if (this.categoryDisableAll.func_146115_a()) {
                    event.getGui().func_146279_a("Disable All Filters", event.getMouseX(), event.getMouseY());
                }
            } else {
                this.buttonWebsite.field_146125_m = false;
                this.buttonYouTube.field_146125_m = false;
                this.buttonTwitter.field_146125_m = false;
                this.buttonPatreon.field_146125_m = false;
                this.categoryUp.field_146125_m = false;
                this.categoryDown.field_146125_m = false;
                this.categoryEnableAll.field_146125_m = false;
                this.categoryDisableAll.field_146125_m = false;
                this.categoryButtons.forEach(guiButton -> {
                    guiButton.field_146125_m = false;
                });
            }
        }
    }

    @SubscribeEvent
    public void onButtonClick(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getButton() instanceof GuiLinkImageButton) {
            GuiLinkImageButton button = (GuiLinkImageButton)event.getButton();
            try {
                this.openWebLink(new URI(button.link));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else if (event.getButton() instanceof GuiCategoryButton) {
            ((GuiCategoryButton)event.getButton()).onClick();
            if (event.getGui() instanceof GuiContainerCreative) {
                GuiContainerCreative creative = (GuiContainerCreative)event.getGui();
                this.updateItems(creative);
            }
        } else if (this.categories != null && event.getGui() instanceof GuiContainerCreative) {
            if (event.getButton() == this.categoryUp) {
                if (startIndex > 0) {
                    --startIndex;
                }
            } else if (event.getButton() == this.categoryDown) {
                if (startIndex <= this.categories.length - 4 - 1) {
                    ++startIndex;
                }
            } else if (event.getButton() == this.categoryEnableAll) {
                for (AbstractCategory category : this.categories) {
                    category.setEnabled(true);
                }
                this.updateItems((GuiContainerCreative)event.getGui());
            } else if (event.getButton() == this.categoryDisableAll) {
                for (AbstractCategory category : this.categories) {
                    category.setEnabled(false);
                }
                this.updateItems((GuiContainerCreative)event.getGui());
            }
            this.updateCategories();
            AbstractCategory[] creative = (AbstractCategory[])event.getGui();
            if (creative.func_147056_g() == MrCrayfishFurnitureMod.tabFurniture.func_78021_a()) {
                this.categoryButtons.forEach(guiCategoryButton -> {
                    guiCategoryButton.field_146125_m = true;
                });
            }
        }
    }

    private void updateItems(GuiContainerCreative creative) {
        GuiContainerCreative.ContainerCreative container = (GuiContainerCreative.ContainerCreative)creative.field_147002_h;
        LinkedHashSet<Item> categorisedItems = new LinkedHashSet<Item>();
        for (AbstractCategory category : this.categories) {
            if (!category.isEnabled()) continue;
            categorisedItems.addAll(category.getItems());
        }
        container.field_148330_a.clear();
        categorisedItems.forEach(item -> item.func_150895_a(CreativeTabs.field_78027_g, container.field_148330_a));
        container.field_148330_a.sort(Comparator.comparingInt(o -> Item.func_150891_b((Item)o.func_77973_b())));
        container.func_148329_a(0.0f);
    }

    private void updateCategoryButtons() {
        this.categoryUp.field_146124_l = startIndex > 0;
        this.categoryDown.field_146124_l = startIndex <= this.categories.length - 4 - 1;
    }

    private void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class GuiImageButton
    extends GuiButton {
        private ResourceLocation resource;
        private int textureU;
        private int textureV;
        private int textureWidth;
        private int textureHeight;

        public GuiImageButton(int x, int y, int textureU, int textureV, int textureWidth, int textureHeight, ResourceLocation resource) {
            super(-1, x, y, textureWidth + 6, textureHeight + 6, "");
            this.resource = resource;
            this.textureU = textureU;
            this.textureV = textureV;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.field_146125_m = false;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_146125_m) {
                return;
            }
            this.field_73735_i = 100.0f;
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            mc.func_110434_K().func_110577_a(this.resource);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + 3, this.field_146129_i + 3, this.textureU, this.textureV, this.textureWidth, this.textureHeight);
            this.field_73735_i = 0.0f;
        }
    }

    private static class GuiArrowButton
    extends GuiButton {
        private static final ResourceLocation ARROWS = new ResourceLocation("textures/gui/resource_packs.png");
        private boolean up = false;

        public GuiArrowButton(int buttonId, int x, int y, int widthIn, int heightIn, boolean up) {
            super(buttonId, x, y, widthIn, heightIn, "");
            this.up = up;
            this.field_146125_m = false;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_146125_m) {
                return;
            }
            this.field_73735_i = 100.0f;
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            mc.func_110434_K().func_110577_a(ARROWS);
            if (this.up) {
                this.func_73729_b(this.field_146128_h + 4, this.field_146129_i + 7, 114, 37, 11, 7);
            } else {
                this.func_73729_b(this.field_146128_h + 4, this.field_146129_i + 7, 82, 52, 11, 7);
            }
            this.field_73735_i = 0.0f;
        }
    }

    private static class GuiCategoryButton
    extends GuiButton {
        private static final ResourceLocation TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
        private int x;
        private int y;
        private boolean toggled;
        private ItemStack stack;
        private AbstractCategory category;

        public GuiCategoryButton(int x, int y, AbstractCategory category) {
            super(0, x, y, 32, 28, "");
            this.x = x;
            this.y = y;
            this.stack = category.getIcon();
            this.toggled = category.isEnabled();
            this.category = category;
            this.field_146125_m = false;
        }

        public void onClick() {
            if (!this.field_146125_m || !this.field_146124_l) {
                return;
            }
            this.toggled = !this.toggled;
            this.category.setEnabled(this.toggled);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_146125_m || !this.field_146124_l) {
                return;
            }
            this.field_146123_n = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.field_146120_f && mouseY < this.y + this.field_146121_g;
            mc.func_110434_K().func_110577_a(TABS);
            GlStateManager.func_179140_f();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            int width = this.toggled ? 32 : 28;
            int textureX = 28;
            int textureY = this.toggled ? 32 : 0;
            this.field_73735_i = 100.0f;
            GlStateManager.func_179126_j();
            this.drawRotatedTexture(this.x, this.y, textureX, textureY, width, 28, 28, width);
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            renderItem.field_77023_b = 100.0f;
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            renderItem.func_180450_b(this.stack, this.x + 8, this.y + 6);
            renderItem.func_175030_a(mc.field_71466_p, this.stack, this.x + 8, this.y + 6);
            renderItem.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
        }

        public void drawHoveringText(GuiScreen screen, int mouseX, int mouseY) {
            if (!this.field_146125_m || !this.field_146124_l) {
                return;
            }
            if (this.field_146123_n) {
                String title = I18n.func_135052_a((String)this.category.getTitleKey(), (Object[])new Object[0]);
                screen.func_146283_a(Arrays.asList(TextFormatting.BOLD + title, this.category.isEnabled() ? TextFormatting.BLUE + "Enabled" : TextFormatting.DARK_GRAY + "Disabled"), mouseX, mouseY);
            }
        }

        private void drawRotatedTexture(int x, int y, int textureX, int textureY, int width, int height, int textureWidth, int textureHeight) {
            float scaleX = 0.00390625f;
            float scaleY = 0.00390625f;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + textureWidth) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + textureWidth) * 0.00390625f), (double)((float)(textureY + textureHeight) * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + textureHeight) * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
            tessellator.func_78381_a();
        }

        public boolean equals(Object obj) {
            return obj instanceof GuiCategoryButton && ((GuiCategoryButton)((Object)obj)).category == this.category;
        }
    }

    private class GuiLinkImageButton
    extends GuiButton {
        private final ResourceLocation image;
        private final int u;
        private final int v;
        private final String link;
        private final String toolTip;

        public GuiLinkImageButton(int buttonId, int x, int y, ResourceLocation image, int u, int v, String link, String toolTip) {
            super(buttonId, x, y, 20, 20, "");
            this.image = image;
            this.u = u;
            this.v = v;
            this.link = link;
            this.toolTip = toolTip;
            this.field_146125_m = false;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                if (this.field_146123_n && !this.func_146116_c(mc, mouseX, mouseY)) {
                    ((FurnitureTab)MrCrayfishFurnitureMod.tabFurniture).setHoveringButton(false);
                }
                this.field_73735_i = 100.0f;
                GlStateManager.func_179126_j();
                FontRenderer fontrenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(field_146122_a);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_146119_b(mc, mouseX, mouseY);
                if (this.field_146123_n) {
                    ((FurnitureTab)MrCrayfishFurnitureMod.tabFurniture).setTitle(this.toolTip);
                    ((FurnitureTab)MrCrayfishFurnitureMod.tabFurniture).setHoveringButton(true);
                }
                mc.func_110434_K().func_110577_a(ICONS);
                this.func_73729_b(this.field_146128_h + 2, this.field_146129_i + 2, this.u, this.v, 16, 16);
                this.field_73735_i = 0.0f;
            }
        }
    }
}

