/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import com.google.common.primitives.Longs;
import com.mrcrayfish.furniture.client.GifCache;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class GifDownloadThread
extends Thread {
    private static final Set<String> LOADING_URLS = new HashSet<String>();
    private static final long MAX_FILE_SIZE = 0x200000L;
    private URI uri;
    private ResponseProcessor processor;
    private int tryCount;

    public GifDownloadThread(URI uri, ResponseProcessor processor) {
        super("Image Download Thread");
        this.uri = uri;
        this.processor = processor;
    }

    @Override
    public void run() {
        String url = this.uri.toString();
        if (GifCache.INSTANCE.loadCached(url)) {
            this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed GIF");
            return;
        }
        if (GifDownloadThread.isLoading(url)) {
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!GifCache.INSTANCE.isCached(url)) continue;
                this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed GIF");
                return;
            } while (this.tryCount++ != 10);
            this.processor.process(ImageDownloadResult.FAILED, "Unable to process GIF");
            return;
        }
        try {
            URLConnection connection = this.uri.toURL().openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
            if (!"image/gif".equals(connection.getContentType())) {
                this.processor.process(ImageDownloadResult.UNKNOWN_FILE, "The file is not a GIF");
                return;
            }
            String lengthString = connection.getHeaderField("Content-Length");
            if (lengthString == null) {
                this.processor.process(ImageDownloadResult.UNKNOWN_SIZE, "Unable to determine size of GIF image");
                return;
            }
            Long length = Longs.tryParse((String)lengthString);
            if (length == null) {
                this.processor.process(ImageDownloadResult.UNKNOWN_SIZE, "Unable to determine size of GIF image");
                return;
            }
            if (length > 0x200000L) {
                this.processor.process(ImageDownloadResult.TOO_LARGE, "The GIF is greater than 2048.0MB");
                return;
            }
            GifDownloadThread.setLoading(url, true);
            byte[] data = IOUtils.toByteArray((URLConnection)connection);
            if (GifCache.INSTANCE.add(url, data)) {
                GifDownloadThread.setLoading(url, false);
                this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed GIF");
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processor.process(ImageDownloadResult.FAILED, "Unable to process GIF");
        GifDownloadThread.setLoading(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoading(String url, boolean loading) {
        Set<String> set = LOADING_URLS;
        synchronized (set) {
            if (loading) {
                LOADING_URLS.add(url);
            } else {
                LOADING_URLS.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoading(String url) {
        Set<String> set = LOADING_URLS;
        synchronized (set) {
            return LOADING_URLS.contains(url);
        }
    }

    public static enum ImageDownloadResult {
        SUCCESS("cfm.tv.success"),
        FAILED("cfm.tv.failed"),
        UNKNOWN_FILE("cfm.tv.unknown_file"),
        UNKNOWN_SIZE("cfm.tv.unknown_size"),
        TOO_LARGE("cfm.tv.too_large"),
        UNTRUSTED("cfm.tv.untrusted"),
        INVALID_URL("cfm.tv.invalid"),
        WRONG_SCHEME("cfm.tv.wrong_scheme"),
        UNSUPPORTED_FILE_TYPE("cfm.tv.unsupported_type");

        private String key;

        private ImageDownloadResult(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static interface ResponseProcessor {
        public void process(ImageDownloadResult var1, String var2);
    }
}

