/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.tileentity.TileEntityToaster;
import com.mrcrayfish.furniture.util.CollisionHelper;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockToaster
extends BlockFurnitureTile {
    private static final AxisAlignedBB BOUNDING_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.3125, 0.0, 0.1875, 0.6875, 0.45, 0.8125);
    private static final AxisAlignedBB BOUNDING_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.3125, 0.0, 0.1875, 0.6875, 0.45, 0.8125);
    private static final AxisAlignedBB BOUNDING_BOX_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.3125, 0.0, 0.1875, 0.6875, 0.45, 0.8125);
    private static final AxisAlignedBB BOUNDING_BOX_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.3125, 0.0, 0.1875, 0.6875, 0.45, 0.8125);
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{BOUNDING_BOX_SOUTH, BOUNDING_BOX_WEST, BOUNDING_BOX_NORTH, BOUNDING_BOX_EAST};
    private static final AxisAlignedBB COLLISION_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.3125, 0.0, 0.1875, 0.6875, 0.4, 0.8125);
    private static final AxisAlignedBB COLLISION_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.3125, 0.0, 0.1875, 0.6875, 0.4, 0.8125);
    private static final AxisAlignedBB COLLISION_BOX_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.3125, 0.0, 0.1875, 0.6875, 0.4, 0.8125);
    private static final AxisAlignedBB COLLISION_BOX_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.3125, 0.0, 0.1875, 0.6875, 0.4, 0.8125);
    private static final AxisAlignedBB[] COLLISION_BOX = new AxisAlignedBB[]{COLLISION_BOX_SOUTH, COLLISION_BOX_WEST, COLLISION_BOX_NORTH, COLLISION_BOX_EAST};

    public BlockToaster(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185858_k);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            Triggers.trigger(Triggers.PLACE_APPLIANCE, (EntityPlayer)placer);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityToaster) {
            TileEntityToaster tileEntityToaster = (TileEntityToaster)tileEntity;
            if (!heldItem.func_190926_b() && !tileEntityToaster.isToasting()) {
                RecipeData data = RecipeAPI.getToasterRecipeFromInput(heldItem);
                if (data != null) {
                    if (tileEntityToaster.addSlice(new ItemStack(heldItem.func_77973_b(), 1))) {
                        TileEntityUtil.markBlockForUpdate(worldIn, pos);
                        heldItem.func_190918_g(1);
                    }
                } else {
                    tileEntityToaster.removeSlice();
                }
            } else if (playerIn.func_70093_af()) {
                if (!tileEntityToaster.isToasting()) {
                    tileEntityToaster.startToasting();
                    worldIn.func_175666_e(pos, (Block)this);
                    if (!worldIn.field_72995_K) {
                        worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, FurnitureSounds.toaster_down, SoundCategory.BLOCKS, 0.75f, 1.0f, false);
                    }
                }
            } else if (!tileEntityToaster.isToasting()) {
                tileEntityToaster.removeSlice();
            }
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BOUNDING_BOX[facing.func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockToaster.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX[facing.func_176736_b()]);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityToaster();
    }

    @Override
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityToaster toaster = (TileEntityToaster)world.func_175625_s(pos);
        return toaster.isToasting() ? 1 : 0;
    }
}

