/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.quark.api.ICollateralMover;
import vazkii.quark.api.INonSticky;

public class QuarkPistonStructureHelper
extends BlockPistonStructureHelper {
    private final BlockPistonStructureHelper parent;
    private final World world;
    private final BlockPos pistonPos;
    private final BlockPos blockToMove;
    private final EnumFacing moveDirection;
    private final List<BlockPos> toMove = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();

    public QuarkPistonStructureHelper(BlockPistonStructureHelper parent, World worldIn, BlockPos posIn, EnumFacing pistonFacing, boolean extending) {
        super(worldIn, posIn, pistonFacing, extending);
        this.parent = parent;
        this.world = worldIn;
        this.pistonPos = posIn;
        if (extending) {
            this.moveDirection = pistonFacing;
            this.blockToMove = posIn.func_177972_a(pistonFacing);
        } else {
            this.moveDirection = pistonFacing.func_176734_d();
            this.blockToMove = posIn.func_177967_a(pistonFacing, 2);
        }
    }

    public boolean func_177253_a() {
        this.toMove.clear();
        this.toDestroy.clear();
        IBlockState iblockstate = this.world.func_180495_p(this.blockToMove);
        if (!BlockPistonBase.func_185646_a((IBlockState)iblockstate, (World)this.world, (BlockPos)this.blockToMove, (EnumFacing)this.moveDirection, (boolean)false, (EnumFacing)this.moveDirection)) {
            if (iblockstate.func_185905_o() == EnumPushReaction.DESTROY) {
                this.toDestroy.add(this.blockToMove);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.blockToMove, this.moveDirection)) {
            return false;
        }
        for (int i2 = 0; i2 < this.toMove.size(); ++i2) {
            BlockPos blockpos = this.toMove.get(i2);
            if (!this.isBlockBranching(this.world, blockpos) || this.addBranchingBlocks(this.world, blockpos) != ICollateralMover.MoveResult.PREVENT) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos origin, EnumFacing face) {
        BlockPos movePos;
        BlockPos target = origin;
        IBlockState iblockstate = this.world.func_180495_p(target);
        if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)this.world, origin) || !BlockPistonBase.func_185646_a((IBlockState)iblockstate, (World)this.world, (BlockPos)origin, (EnumFacing)this.moveDirection, (boolean)false, (EnumFacing)face) || origin.equals((Object)this.pistonPos) || this.toMove.contains(origin)) {
            return true;
        }
        int lineLen = 1;
        if (lineLen + this.toMove.size() > 12) {
            return false;
        }
        BlockPos oldPos = origin;
        IBlockState oldState = this.world.func_180495_p(origin);
        boolean skippingNext = false;
        while (this.isBlockBranching(this.world, target)) {
            ICollateralMover.MoveResult res = this.getBranchResult(this.world, target);
            if (res == ICollateralMover.MoveResult.PREVENT) {
                return false;
            }
            if (res != ICollateralMover.MoveResult.MOVE) {
                skippingNext = true;
                break;
            }
            target = origin.func_177967_a(this.moveDirection.func_176734_d(), lineLen);
            iblockstate = this.world.func_180495_p(target);
            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)this.world, target) || !BlockPistonBase.func_185646_a((IBlockState)iblockstate, (World)this.world, (BlockPos)target, (EnumFacing)this.moveDirection, (boolean)false, (EnumFacing)this.moveDirection.func_176734_d()) || target.equals((Object)this.pistonPos) || this.getStickCompatibility(this.world, iblockstate, oldState, target, oldPos, this.moveDirection) != ICollateralMover.MoveResult.MOVE) break;
            oldState = iblockstate;
            oldPos = target;
            if (++lineLen + this.toMove.size() <= 12) continue;
            return false;
        }
        int i1 = 0;
        for (int j = lineLen - 1; j >= 0 && !this.toDestroy.contains(movePos = origin.func_177967_a(this.moveDirection.func_176734_d(), j)); --j) {
            this.toMove.add(movePos);
            ++i1;
        }
        if (skippingNext) {
            return true;
        }
        int j1 = 1;
        while (true) {
            BlockPos blockpos1 = origin.func_177967_a(this.moveDirection, j1);
            int k = this.toMove.indexOf(blockpos1);
            ICollateralMover.MoveResult res = ICollateralMover.MoveResult.MOVE;
            if (k > -1) {
                this.reorderListAtCollision(i1, k);
                for (int l = 0; l <= k + i1; ++l) {
                    BlockPos blockpos2 = this.toMove.get(l);
                    if (!this.isBlockBranching(this.world, blockpos2) || (res = this.addBranchingBlocks(this.world, blockpos2)) != ICollateralMover.MoveResult.PREVENT) continue;
                    return false;
                }
                return true;
            }
            if (res != ICollateralMover.MoveResult.MOVE) continue;
            iblockstate = this.world.func_180495_p(blockpos1);
            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)this.world, blockpos1)) {
                return true;
            }
            if (!BlockPistonBase.func_185646_a((IBlockState)iblockstate, (World)this.world, (BlockPos)blockpos1, (EnumFacing)this.moveDirection, (boolean)true, (EnumFacing)this.moveDirection) || blockpos1.equals((Object)this.pistonPos)) {
                return false;
            }
            if (iblockstate.func_185905_o() == EnumPushReaction.DESTROY) {
                this.toDestroy.add(blockpos1);
                this.toMove.remove(blockpos1);
                return true;
            }
            boolean doneFinding = false;
            if (this.isBlockBranching(this.world, blockpos1)) {
                res = this.getBranchResult(this.world, blockpos1);
                if (res == ICollateralMover.MoveResult.PREVENT) {
                    return false;
                }
                if (res != ICollateralMover.MoveResult.MOVE) {
                    doneFinding = true;
                }
            }
            if (this.toMove.size() >= 12) {
                return false;
            }
            this.toMove.add(blockpos1);
            ++i1;
            ++j1;
            if (doneFinding) break;
        }
        return true;
    }

    private void reorderListAtCollision(int p_177255_1_, int p_177255_2_) {
        ArrayList list2 = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list22 = Lists.newArrayList();
        list2.addAll(this.toMove.subList(0, p_177255_2_));
        list1.addAll(this.toMove.subList(this.toMove.size() - p_177255_1_, this.toMove.size()));
        list22.addAll(this.toMove.subList(p_177255_2_, this.toMove.size() - p_177255_1_));
        this.toMove.clear();
        this.toMove.addAll(list2);
        this.toMove.addAll(list1);
        this.toMove.addAll(list22);
    }

    private ICollateralMover.MoveResult addBranchingBlocks(World world, BlockPos fromPos) {
        IBlockState state = world.func_180495_p(fromPos);
        Block block = state.func_177230_c();
        EnumFacing opposite = this.moveDirection.func_176734_d();
        ICollateralMover.MoveResult retResult = ICollateralMover.MoveResult.SKIP;
        for (EnumFacing face : EnumFacing.values()) {
            BlockPos targetPos = fromPos.func_177972_a(face);
            IBlockState targetState = world.func_180495_p(targetPos);
            ICollateralMover.MoveResult res = block instanceof ICollateralMover ? ((ICollateralMover)block).getCollateralMovement(world, this.pistonPos, this.moveDirection, face, fromPos) : this.getStickCompatibility(world, state, targetState, fromPos, targetPos, face);
            switch (res) {
                case PREVENT: {
                    return ICollateralMover.MoveResult.PREVENT;
                }
                case MOVE: {
                    if (this.addBlockLine(targetPos, face)) break;
                    return ICollateralMover.MoveResult.PREVENT;
                }
                case BREAK: {
                    if (BlockPistonBase.func_185646_a((IBlockState)targetState, (World)world, (BlockPos)targetPos, (EnumFacing)this.moveDirection, (boolean)true, (EnumFacing)this.moveDirection)) {
                        this.toDestroy.add(targetPos);
                        this.toMove.remove(targetPos);
                        return ICollateralMover.MoveResult.BREAK;
                    }
                    return ICollateralMover.MoveResult.PREVENT;
                }
            }
            if (face != opposite) continue;
            retResult = res;
        }
        return retResult;
    }

    private boolean isBlockBranching(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof ICollateralMover ? ((ICollateralMover)block).isCollateralMover(world, this.pistonPos, this.moveDirection, pos) : state.func_177230_c().isStickyBlock(state);
    }

    private ICollateralMover.MoveResult getBranchResult(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof ICollateralMover) {
            return ((ICollateralMover)block).getCollateralMovement(world, this.pistonPos, this.moveDirection, this.moveDirection, pos);
        }
        return ICollateralMover.MoveResult.MOVE;
    }

    private ICollateralMover.MoveResult getStickCompatibility(World world, IBlockState state1, IBlockState state2, BlockPos pos1, BlockPos pos2, EnumFacing face) {
        Block block = state1.func_177230_c();
        if (block instanceof INonSticky && !((INonSticky)block).canStickToBlock(world, this.pistonPos, pos1, pos2, state1, state2, this.moveDirection)) {
            return ICollateralMover.MoveResult.SKIP;
        }
        block = state2.func_177230_c();
        if (block instanceof INonSticky && !((INonSticky)block).canStickToBlock(world, this.pistonPos, pos2, pos1, state2, state1, this.moveDirection)) {
            return ICollateralMover.MoveResult.SKIP;
        }
        return ICollateralMover.MoveResult.MOVE;
    }

    @Nonnull
    public List<BlockPos> func_177254_c() {
        return this.toMove;
    }

    @Nonnull
    public List<BlockPos> func_177252_d() {
        return this.toDestroy;
    }
}

