/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.panda;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import thedarkcolour.core.util.UtilKt;
import thedarkcolour.futuremc.entity.panda.EntityPanda;
import thedarkcolour.futuremc.entity.panda.LayerPandaHeldItem;
import thedarkcolour.futuremc.entity.panda.ModelPanda;

public class RenderPanda
extends RenderLiving<EntityPanda> {
    private static final Map<EntityPanda.PandaType, ResourceLocation> textures = UtilKt.make(Maps.newHashMap(), map -> {
        map.put(EntityPanda.PandaType.NORMAL, new ResourceLocation("futuremc:textures/entity/panda/panda.png"));
        map.put(EntityPanda.PandaType.LAZY, new ResourceLocation("futuremc:textures/entity/panda/lazy_panda.png"));
        map.put(EntityPanda.PandaType.WORRIED, new ResourceLocation("futuremc:textures/entity/panda/worried_panda.png"));
        map.put(EntityPanda.PandaType.PLAYFUL, new ResourceLocation("futuremc:textures/entity/panda/playful_panda.png"));
        map.put(EntityPanda.PandaType.BROWN, new ResourceLocation("futuremc:textures/entity/panda/brown_panda.png"));
        map.put(EntityPanda.PandaType.WEAK, new ResourceLocation("futuremc:textures/entity/panda/weak_panda.png"));
        map.put(EntityPanda.PandaType.AGGRESSIVE, new ResourceLocation("futuremc:textures/entity/panda/aggressive_panda.png"));
    });

    public RenderPanda(RenderManager manager) {
        super(manager, (ModelBase)new ModelPanda(9, 0.0f), 0.9f);
        this.func_177094_a(new LayerPandaHeldItem());
    }

    protected ResourceLocation getEntityTexture(EntityPanda entity) {
        return textures.getOrDefault(entity.getPandaType(), textures.get(EntityPanda.PandaType.NORMAL));
    }

    protected void applyRotations(EntityPanda entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        float f8;
        super.func_77043_a((EntityLivingBase)entityLiving, ageInTicks, rotationYaw, partialTicks);
        if (entityLiving.rolls > 0) {
            float f1;
            int i2 = entityLiving.rolls;
            int j = i2 + 1;
            float f = f1 = entityLiving.func_70631_g_() ? 0.3f : 0.8f;
            if (i2 < 8) {
                float f3 = (float)(90 * i2) / 7.0f;
                float f4 = (float)(90 * j) / 7.0f;
                float f2 = this.func_217775_a(f3, f4, j, partialTicks, 8.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)((f1 + 0.2f) * (f2 / 90.0f)), (float)0.0f);
                GlStateManager.func_179114_b((float)(-f2), (float)1.0f, (float)0.0f, (float)0.0f);
            } else if (i2 < 16) {
                float f13 = ((float)i2 - 8.0f) / 7.0f;
                float f16 = 90.0f + 90.0f * f13;
                float f5 = 90.0f + 90.0f * ((float)j - 8.0f) / 7.0f;
                float f10 = this.func_217775_a(f16, f5, j, partialTicks, 16.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(f1 + 0.2f + (f1 - 0.2f) * (f10 - 90.0f) / 90.0f), (float)0.0f);
                GlStateManager.func_179114_b((float)(-f10), (float)1.0f, (float)0.0f, (float)0.0f);
            } else if ((float)i2 < 24.0f) {
                float f14 = ((float)i2 - 16.0f) / 7.0f;
                float f17 = 180.0f + 90.0f * f14;
                float f19 = 180.0f + 90.0f * ((float)j - 16.0f) / 7.0f;
                float f11 = this.func_217775_a(f17, f19, j, partialTicks, 24.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(f1 + f1 * (270.0f - f11) / 90.0f), (float)0.0f);
                GlStateManager.func_179114_b((float)(-f11), (float)1.0f, (float)0.0f, (float)0.0f);
            } else if (i2 < 32) {
                float f15 = ((float)i2 - 24.0f) / 7.0f;
                float f18 = 270.0f + 90.0f * f15;
                float f20 = 270.0f + 90.0f * ((float)j - 24.0f) / 7.0f;
                float f12 = this.func_217775_a(f18, f20, j, partialTicks, 32.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(f1 * ((360.0f - f12) / 90.0f)), (float)0.0f);
                GlStateManager.func_179114_b((float)(-f12), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float f6 = entityLiving.getScaredAnimation(partialTicks);
        if (f6 > 0.0f) {
            GlStateManager.func_179109_b((float)0.0f, (float)(0.8f * f6), (float)0.0f);
            GlStateManager.func_179114_b((float)UtilKt.lerp(f6, entityLiving.field_70125_A, entityLiving.field_70125_A + 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(-1.0f * f6), (float)0.0f);
            if (entityLiving.isFrightened()) {
                float f7 = (float)(Math.cos((double)entityLiving.field_70173_aa * 1.25) * Math.PI * (double)0.05f);
                GlStateManager.func_179114_b((float)f7, (float)0.0f, (float)1.0f, (float)0.0f);
                if (entityLiving.func_70631_g_()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.8f, (float)0.55f);
                }
            }
        }
        if ((f8 = entityLiving.getLazyAnimation(partialTicks)) > 0.0f) {
            float f9 = entityLiving.func_70631_g_() ? 0.5f : 1.3f;
            GlStateManager.func_179109_b((float)0.0f, (float)(f9 * f8), (float)0.0f);
            GlStateManager.func_179114_b((float)UtilKt.lerp(f8, entityLiving.field_70125_A, entityLiving.field_70125_A + 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private float func_217775_a(float p_217775_1_, float p_217775_2_, int p_217775_3_, float partialTicks, float p_217775_5_) {
        return (float)p_217775_3_ < p_217775_5_ ? UtilKt.lerp(partialTicks, p_217775_1_, p_217775_2_) : p_217775_1_;
    }
}

