/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.block.BlockBOPHive;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorReplacing;
import biomesoplenty.core.BiomesOPlenty;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorHive
extends GeneratorReplacing {
    protected int halfHeight;
    protected int maxRadius;
    protected int layerSize;
    protected int bottomExtra;
    protected float emptyChance;

    public GeneratorHive(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int halfHeight, int maxRadius, int layerSize, int bottomExtra, float emptyChance) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.halfHeight = halfHeight;
        this.maxRadius = maxRadius;
        this.layerSize = layerSize;
        this.bottomExtra = bottomExtra;
        this.emptyChance = emptyChance;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        if (!this.canPlaceHere(world, position)) {
            return false;
        }
        boolean empty = rand.nextFloat() <= this.emptyChance;
        for (int yOffset = this.halfHeight; yOffset >= -this.halfHeight - this.bottomExtra; --yOffset) {
            int radius = this.maxRadius + yOffset / this.layerSize * (yOffset >= 0 ? -1 : 1);
            for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
                for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                    int x2_z2 = xOffset * xOffset + zOffset * zOffset;
                    boolean bottomHalf = yOffset <= 0;
                    boolean outerCap = yOffset == -this.halfHeight - this.bottomExtra || yOffset == this.halfHeight;
                    boolean innerCap = yOffset == -this.halfHeight - this.bottomExtra + 1 || yOffset == this.halfHeight - 1;
                    BlockPos realPos = position.func_177982_a(xOffset, yOffset - this.halfHeight, zOffset);
                    if (x2_z2 <= (radius - 1) * (radius - 1) + 1 && (x2_z2 >= (radius - 2) * (radius - 2) || innerCap)) {
                        IBlockState honeyComb = BOPBlocks.hive.func_176223_P().func_177226_a((IProperty)BlockBOPHive.VARIANT, (Comparable)((Object)BlockBOPHive.HiveType.EMPTY_HONEYCOMB));
                        float f = rand.nextFloat();
                        if (!empty && (double)f <= 0.95) {
                            honeyComb = BOPBlocks.hive.func_176223_P().func_177226_a((IProperty)BlockBOPHive.VARIANT, (Comparable)((Object)BlockBOPHive.HiveType.HONEYCOMB));
                            if ((double)f <= 0.2 || (double)f <= 0.65 && bottomHalf) {
                                honeyComb = BOPBlocks.hive.func_176223_P().func_177226_a((IProperty)BlockBOPHive.VARIANT, (Comparable)((Object)BlockBOPHive.HiveType.FILLED_HONEYCOMB));
                            }
                        } else if (empty && (double)f <= 0.2) {
                            honeyComb = Blocks.field_150350_a.func_176223_P();
                        }
                        world.func_180501_a(realPos, honeyComb, 2);
                    }
                    if (!empty && bottomHalf && x2_z2 <= (radius - 2) * (radius - 2) + 1) {
                        IBlockState fillBlock;
                        IBlockState iBlockState = fillBlock = yOffset == 0 ? BOPBlocks.honey_block.func_176223_P() : BOPBlocks.honey.func_176223_P();
                        if (world.func_180495_p(realPos).func_185904_a() == Material.field_151579_a) {
                            world.func_180501_a(realPos, fillBlock, 2);
                        }
                    }
                    if (!empty && yOffset == 0 && xOffset == 0 && zOffset == 0) {
                        world.func_180501_a(realPos, Blocks.field_150474_ac.func_176223_P(), 2);
                        TileEntity tileentity = world.func_175625_s(realPos);
                        if (tileentity instanceof TileEntityMobSpawner) {
                            MobSpawnerBaseLogic spawnerLogic = ((TileEntityMobSpawner)tileentity).func_145881_a();
                            NBTTagCompound spawnerConfig = new NBTTagCompound();
                            spawnerConfig.func_74777_a("MinSpawnDelay", (short)100);
                            spawnerConfig.func_74777_a("MaxSpawnDelay", (short)250);
                            spawnerConfig.func_74777_a("SpawnCount", (short)2);
                            spawnerConfig.func_74777_a("MaxNearbyEntities", (short)10);
                            spawnerConfig.func_74777_a("RequiredPlayerRange", (short)48);
                            spawnerLogic.func_98270_a(spawnerConfig);
                            spawnerLogic.func_190894_a(new ResourceLocation("biomesoplenty", "wasp"));
                        } else {
                            BiomesOPlenty.logger.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{realPos.func_177958_n(), realPos.func_177956_o(), realPos.func_177952_p()});
                        }
                    }
                    if (x2_z2 > radius * radius + 1 || x2_z2 < (radius - 1) * (radius - 1) && !outerCap) continue;
                    world.func_180501_a(realPos, BOPBlocks.hive.func_176223_P(), 2);
                }
            }
        }
        return true;
    }

    public boolean canPlaceHere(World world, BlockPos pos) {
        if (pos.func_177956_o() <= 1 || pos.func_177956_o() > 255) {
            return false;
        }
        for (int y = this.halfHeight; y >= -this.halfHeight - this.bottomExtra; --y) {
            int radius = this.maxRadius + y / this.layerSize * (y >= 0 ? -1 : 1);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x == 0 && z == 0 && y == this.halfHeight && !this.placeOn.matches(world, pos.func_177982_a(x, y - this.halfHeight + 1, z))) {
                        return false;
                    }
                    if (this.replace.matches(world, pos.func_177982_a(x, y - this.halfHeight, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.placeOn = conf.getBlockPosQuery("placeUnder", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.scatterYMethod = conf.getEnum("scatterYMethod", this.scatterYMethod, GeneratorUtils.ScatterYMethod.class);
        this.halfHeight = conf.getInt("halfHeight", this.halfHeight);
        this.maxRadius = conf.getInt("maxRadius", this.maxRadius);
        this.layerSize = conf.getInt("layerSize", this.layerSize);
        this.bottomExtra = conf.getInt("bottomExtra", this.bottomExtra);
        this.emptyChance = conf.getFloat("emptyChance", Float.valueOf(this.emptyChance)).floatValue();
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorHive>
    implements IGenerator.IGeneratorBuilder<GeneratorHive> {
        protected int halfHeight;
        protected int maxRadius;
        protected int layerSize;
        protected int bottomExtra;
        protected float emptyChance;

        public Builder halfHeight(int a) {
            this.halfHeight = a;
            return (Builder)this.self();
        }

        public Builder maxRadius(int a) {
            this.maxRadius = a;
            return (Builder)this.self();
        }

        public Builder layerSize(int a) {
            this.layerSize = a;
            return (Builder)this.self();
        }

        public Builder bottomExtra(int a) {
            this.bottomExtra = a;
            return (Builder)this.self();
        }

        public Builder emptyChance(float a) {
            this.emptyChance = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQuery.buildAnd().states(Blocks.field_150424_aL.func_176223_P()).withAirBelow().create();
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151579_a);
            this.with = null;
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.NETHER_ROOF;
            this.halfHeight = 7;
            this.maxRadius = 9;
            this.layerSize = 3;
            this.bottomExtra = 4;
            this.emptyChance = 0.25f;
        }

        @Override
        public GeneratorHive create() {
            return new GeneratorHive(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.halfHeight, this.maxRadius, this.layerSize, this.bottomExtra, this.emptyChance);
        }
    }
}

