/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.handler;

import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.config.MiscConfigurationHandler;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class FogEventHandler {
    private static double fogX;
    private static double fogZ;
    private static boolean fogInit;
    private static float fogFarPlaneDistance;

    @SubscribeEvent
    public void onGetFogColor(EntityViewRenderEvent.FogColors event) {
        if (!MiscConfigurationHandler.enableFogColours) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            World world = player.field_70170_p;
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            IBlockState stateAtEyes = ActiveRenderInfo.func_186703_a((World)world, (Entity)event.getEntity(), (float)((float)event.getRenderPartialTicks()));
            if (stateAtEyes.func_185904_a() == Material.field_151587_i) {
                return;
            }
            Vec3d mixedColor = stateAtEyes.func_185904_a() == Material.field_151586_h ? FogEventHandler.getFogBlendColorWater(world, (EntityLivingBase)player, x, y, z, event.getRenderPartialTicks()) : FogEventHandler.getFogBlendColour(world, (EntityLivingBase)player, x, y, z, event.getRed(), event.getGreen(), event.getBlue(), event.getRenderPartialTicks());
            event.setRed((float)mixedColor.field_72450_a);
            event.setGreen((float)mixedColor.field_72448_b);
            event.setBlue((float)mixedColor.field_72449_c);
        }
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        Entity entity = event.getEntity();
        World world = entity.field_70170_p;
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        if ((double)playerX == fogX && (double)playerZ == fogZ && fogInit) {
            FogEventHandler.renderFog(event.getFogMode(), fogFarPlaneDistance, 0.75f);
            return;
        }
        fogInit = true;
        int distance = 20;
        float fpDistanceBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                pos.func_181079_c(playerX + x, 0, playerZ + z);
                Biome biome = world.func_180494_b((BlockPos)pos);
                if (!(biome instanceof BOPBiome)) continue;
                float distancePart = ((BOPBiome)biome).getFogDensity((BlockPos)pos);
                float weightPart = 1.0f;
                if (x == -distance) {
                    xDiff = 1.0 - (entity.field_70165_t - (double)playerX);
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == distance) {
                    xDiff = entity.field_70165_t - (double)playerX;
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (entity.field_70161_v - (double)playerZ);
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == distance) {
                    zDiff = entity.field_70161_v - (double)playerZ;
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                }
                fpDistanceBiomeFog += distancePart;
                weightBiomeFog += weightPart;
            }
        }
        float weightMixed = distance * 2 * (distance * 2);
        float weightDefault = weightMixed - weightBiomeFog;
        float fpDistanceBiomeFogAvg = weightBiomeFog == 0.0f ? 0.0f : fpDistanceBiomeFog / weightBiomeFog;
        float farPlaneDistance = (fpDistanceBiomeFog * 240.0f + event.getFarPlaneDistance() * weightDefault) / weightMixed;
        float farPlaneDistanceScaleBiome = 0.1f * (1.0f - fpDistanceBiomeFogAvg) + 0.75f * fpDistanceBiomeFogAvg;
        float farPlaneDistanceScale = (farPlaneDistanceScaleBiome * weightBiomeFog + 0.75f * weightDefault) / weightMixed;
        fogX = entity.field_70165_t;
        fogZ = entity.field_70161_v;
        fogFarPlaneDistance = Math.min(farPlaneDistance, event.getFarPlaneDistance());
        FogEventHandler.renderFog(event.getFogMode(), fogFarPlaneDistance, farPlaneDistanceScale);
    }

    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
        if (fogMode < 0) {
            GL11.glFogf((int)2915, (float)0.0f);
            GL11.glFogf((int)2916, (float)farPlaneDistance);
        } else {
            GL11.glFogf((int)2915, (float)(farPlaneDistance * farPlaneDistanceScale));
            GL11.glFogf((int)2916, (float)farPlaneDistance);
        }
    }

    private static Vec3d postProcessColor(World world, EntityLivingBase player, double r, double g, double b, double renderPartialTicks) {
        int duration;
        double darkScale = (player.field_70137_T + (player.field_70163_u - player.field_70137_T) * renderPartialTicks) * world.field_73011_w.func_76565_k();
        if (player.func_70644_a(MobEffects.field_76440_q)) {
            duration = player.func_70660_b(MobEffects.field_76440_q).func_76459_b();
            darkScale *= duration < 20 ? (double)(1.0f - (float)duration / 20.0f) : 0.0;
        }
        if (darkScale < 1.0) {
            darkScale = darkScale < 0.0 ? 0.0 : darkScale * darkScale;
            r *= darkScale;
            g *= darkScale;
            b *= darkScale;
        }
        if (player.func_70644_a(MobEffects.field_76439_r)) {
            duration = player.func_70660_b(MobEffects.field_76439_r).func_76459_b();
            float brightness = duration > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)((float)(((double)duration - renderPartialTicks) * Math.PI * (double)0.2f))) * 0.3f;
            double scale = 1.0 / r;
            scale = Math.min(scale, 1.0 / g);
            scale = Math.min(scale, 1.0 / b);
            r = r * (double)(1.0f - brightness) + r * scale * (double)brightness;
            g = g * (double)(1.0f - brightness) + g * scale * (double)brightness;
            b = b * (double)(1.0f - brightness) + b * scale * (double)brightness;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
            double aR = (r * 30.0 + g * 59.0 + b * 11.0) / 100.0;
            double aG = (r * 30.0 + g * 70.0) / 100.0;
            double aB = (r * 30.0 + b * 70.0) / 100.0;
            r = aR;
            g = aG;
            b = aB;
        }
        return new Vec3d(r, g, b);
    }

    private static Vec3d getFogBlendColorWater(World world, EntityLivingBase playerEntity, int playerX, int playerY, int playerZ, double renderPartialTicks) {
        int distance = 2;
        float rBiomeFog = 0.0f;
        float gBiomeFog = 0.0f;
        float bBiomeFog = 0.0f;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                pos.func_181079_c(playerX + x, 0, playerZ + z);
                Biome biome = world.func_180494_b((BlockPos)pos);
                int waterColorMult = biome.func_185361_o();
                float rPart = (waterColorMult & 0xFF0000) >> 16;
                float gPart = (waterColorMult & 0xFF00) >> 8;
                float bPart = waterColorMult & 0xFF;
                if (x == -distance) {
                    xDiff = 1.0 - (playerEntity.field_70165_t - (double)playerX);
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                } else if (x == distance) {
                    xDiff = playerEntity.field_70165_t - (double)playerX;
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (playerEntity.field_70161_v - (double)playerZ);
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                } else if (z == distance) {
                    zDiff = playerEntity.field_70161_v - (double)playerZ;
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                }
                rBiomeFog += rPart;
                gBiomeFog += gPart;
                bBiomeFog += bPart;
            }
        }
        float weight = distance * 2 * (distance * 2);
        float respirationLevel = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)playerEntity) * 0.2f;
        float rMixed = ((rBiomeFog /= 255.0f) * 0.02f + respirationLevel) / weight;
        float gMixed = ((gBiomeFog /= 255.0f) * 0.02f + respirationLevel) / weight;
        float bMixed = ((bBiomeFog /= 255.0f) * 0.2f + respirationLevel) / weight;
        return FogEventHandler.postProcessColor(world, playerEntity, rMixed, gMixed, bMixed, renderPartialTicks);
    }

    private static Vec3d getFogBlendColour(World world, EntityLivingBase playerEntity, int playerX, int playerY, int playerZ, float defR, float defG, float defB, double renderPartialTicks) {
        float thunderStrength;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 6;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        double rBiomeFog = 0.0;
        double gBiomeFog = 0.0;
        double bBiomeFog = 0.0;
        double weightBiomeFog = 0.0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                int fogColour;
                pos.func_181079_c(playerX + x, 0, playerZ + z);
                Biome biome = world.func_180494_b((BlockPos)pos);
                if (!(biome instanceof BOPBiome) || (fogColour = ((BOPBiome)biome).getFogColor((BlockPos)pos)) < 0) continue;
                double rPart = (fogColour & 0xFF0000) >> 16;
                double gPart = (fogColour & 0xFF00) >> 8;
                double bPart = fogColour & 0xFF;
                float weightPart = 1.0f;
                if (x == -distance) {
                    xDiff = 1.0 - (playerEntity.field_70165_t - (double)playerX);
                    rPart *= xDiff;
                    gPart *= xDiff;
                    bPart *= xDiff;
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == distance) {
                    xDiff = playerEntity.field_70165_t - (double)playerX;
                    rPart *= xDiff;
                    gPart *= xDiff;
                    bPart *= xDiff;
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (playerEntity.field_70161_v - (double)playerZ);
                    rPart *= zDiff;
                    gPart *= zDiff;
                    bPart *= zDiff;
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == distance) {
                    zDiff = playerEntity.field_70161_v - (double)playerZ;
                    rPart *= zDiff;
                    gPart *= zDiff;
                    bPart *= zDiff;
                    weightPart = (float)((double)weightPart * zDiff);
                }
                rBiomeFog += rPart;
                gBiomeFog += gPart;
                bBiomeFog += bPart;
                weightBiomeFog += (double)weightPart;
            }
        }
        if (weightBiomeFog == 0.0 || distance == 0) {
            return new Vec3d((double)defR, (double)defG, (double)defB);
        }
        rBiomeFog /= 255.0;
        gBiomeFog /= 255.0;
        bBiomeFog /= 255.0;
        float celestialAngle = world.func_72826_c((float)renderPartialTicks);
        float baseScale = MathHelper.func_76131_a((float)(MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        double rScale = baseScale * 0.94f + 0.06f;
        double gScale = baseScale * 0.94f + 0.06f;
        double bScale = baseScale * 0.91f + 0.09f;
        float rainStrength = world.func_72867_j((float)renderPartialTicks);
        if (rainStrength > 0.0f) {
            rScale *= (double)(1.0f - rainStrength * 0.5f);
            gScale *= (double)(1.0f - rainStrength * 0.5f);
            bScale *= (double)(1.0f - rainStrength * 0.4f);
        }
        if ((thunderStrength = world.func_72819_i((float)renderPartialTicks)) > 0.0f) {
            rScale *= (double)(1.0f - thunderStrength * 0.5f);
            gScale *= (double)(1.0f - thunderStrength * 0.5f);
            bScale *= (double)(1.0f - thunderStrength * 0.5f);
        }
        Vec3d processedColor = FogEventHandler.postProcessColor(world, playerEntity, rBiomeFog *= rScale / weightBiomeFog, gBiomeFog *= gScale / weightBiomeFog, bBiomeFog *= bScale / weightBiomeFog, renderPartialTicks);
        rBiomeFog = processedColor.field_72450_a;
        gBiomeFog = processedColor.field_72448_b;
        bBiomeFog = processedColor.field_72449_c;
        double weightMixed = distance * 2 * (distance * 2);
        double weightDefault = weightMixed - weightBiomeFog;
        double rFinal = (rBiomeFog * weightBiomeFog + (double)defR * weightDefault) / weightMixed;
        double gFinal = (gBiomeFog * weightBiomeFog + (double)defG * weightDefault) / weightMixed;
        double bFinal = (bBiomeFog * weightBiomeFog + (double)defB * weightDefault) / weightMixed;
        return new Vec3d(rFinal, gFinal, bFinal);
    }
}

