/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPCoral;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPDoublePlant;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.GeneratorDoubleFlora;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorLakes;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWaterside;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeGenMoor
extends BOPOverworldBiome {
    public BiomeGenMoor() {
        super("moor", new BOPBiome.PropsBuilder("Moor").withGuiColour(6394725).withTemperature(Float.valueOf(0.6f)).withRainfall(Float.valueOf(1.0f)).withWaterColor(5800566));
        this.terrainSettings.avgHeight(88.0).heightVariation(8.0, 10.0).octaves(0.0, 1.0, 1.0, 3.0, 1.0, 0.0);
        this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.LOAMY));
        this.field_76753_B = BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.LOAMY));
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.beachBiomeLocation = null;
        this.addWeight(BOPClimates.COLD_SWAMP, 5);
        this.addGenerator("mud", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(1.0f)).maxRadius(7).with(BOPBlocks.mud.func_176223_P())).create());
        this.addGenerator("lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(1.5f)).waterLakeForBiome(this).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(0.6f);
        this.addGenerator("flowers", GeneratorStage.FLOWERS, flowerGenerator);
        flowerGenerator.add("swampflower", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.SWAMPFLOWER)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(2.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        grassGenerator.add("mediumgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("shortgrass", 3, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        this.addGenerator("brown_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).generationAttempts(16)).with(Blocks.field_150338_P.func_176223_P())).create());
        this.addGenerator("red_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).generationAttempts(16)).with(Blocks.field_150337_Q.func_176223_P())).create());
        this.addGenerator("koru", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.6f)).with(BOPPlants.KORU)).create());
        this.addGenerator("flax", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPDoublePlant.DoublePlantType.FLAX).generationAttempts(6).create());
        this.addGenerator("algae", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(5.0f)).replace((Block)Blocks.field_150355_j)).with(BOPBlocks.coral.func_176223_P().func_177226_a((IProperty)BlockBOPCoral.VARIANT, (Comparable)((Object)BlockBOPCoral.CoralType.ALGAE)))).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_GROUND)).create());
        this.addGenerator("malachite", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.MALACHITE)).create());
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(worldIn, rand, pos);
        }
    }

    public int func_180627_b(BlockPos pos) {
        return this.getModdedBiomeGrassColor(6394725);
    }

    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(6394725);
    }
}

