/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders;

import com.anthonyhilyard.itemborders.config.ItemBordersConfig;
import com.anthonyhilyard.itemborders.util.TextColor;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="itemborders", name="Item Borders", version="1.2.0", acceptedMinecraftVersions="[1.12.2]", clientSideOnly=true)
@Mod.EventBusSubscriber(modid="itemborders", value={Side.CLIENT})
public class ItemBorders {
    public static final String MODID = "itemborders";
    public static final String MODNAME = "Item Borders";
    public static final String MODVERSION = "1.2.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"itemborders");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ItemBordersConfig.loadConfig(event.getSuggestedConfigurationFile());
    }

    public static void renderBorder(Slot slot) {
        ItemBorders.render(slot.func_75211_c(), slot.field_75223_e, slot.field_75221_f);
    }

    public static void renderBorder(ItemStack item, int x, int y) {
        if (ItemBordersConfig.INSTANCE.hotBar) {
            ItemBorders.render(item, x, y);
        }
    }

    private static void render(ItemStack item, int x, int y) {
        if (item.func_190926_b()) {
            return;
        }
        Pair borderColors = ItemBordersConfig.INSTANCE.getBorderColorForItem(item);
        if (borderColors == null) {
            borderColors = Pair.of(() -> TextColor.parseColor("white"), () -> TextColor.parseColor("white"));
        }
        if (((Integer)((Supplier)borderColors.getLeft()).get() & 0xFFFFFF) == TextColor.parseColor("white") && ((Integer)((Supplier)borderColors.getRight()).get() & 0xFFFFFF) == TextColor.parseColor("white") && !ItemBordersConfig.INSTANCE.showForCommon) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(ItemBordersConfig.INSTANCE.overItems ? 290.0f : 100.0f));
        int startColor = (Integer)((Supplier)borderColors.getLeft()).get() & 0xFFFFFF;
        int endColor = (Integer)((Supplier)borderColors.getRight()).get() & 0xFFFFFF;
        int topColor = ItemBordersConfig.INSTANCE.fullBorder ? startColor | 0xEE000000 : startColor;
        int bottomColor = endColor | 0xEE000000;
        int xOffset = ItemBordersConfig.INSTANCE.squareCorners ? 0 : 1;
        GuiUtils.drawGradientRect((int)-1, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + 15), (int)topColor, (int)bottomColor);
        GuiUtils.drawGradientRect((int)-1, (int)(x + 15), (int)(y + 1), (int)(x + 16), (int)(y + 15), (int)topColor, (int)bottomColor);
        GuiUtils.drawGradientRect((int)-1, (int)(x + xOffset), (int)y, (int)(x + 16 - xOffset), (int)(y + 1), (int)topColor, (int)topColor);
        GuiUtils.drawGradientRect((int)-1, (int)(x + xOffset), (int)(y + 15), (int)(x + 16 - xOffset), (int)(y + 16), (int)bottomColor, (int)bottomColor);
        if (ItemBordersConfig.INSTANCE.extraGlow) {
            int topAlpha = (topColor >> 24 & 0xFF) / 3;
            int bottomAlpha = (bottomColor >> 24 & 0xFF) / 3;
            int topGlowColor = topAlpha << 24 | topColor & 0xFFFFFF;
            int bottomGlowColor = bottomAlpha << 24 | bottomColor & 0xFFFFFF;
            GuiUtils.drawGradientRect((int)-1, (int)(x + 1), (int)(y + 1), (int)(x + 2), (int)(y + 15), (int)topGlowColor, (int)bottomGlowColor);
            GuiUtils.drawGradientRect((int)-1, (int)(x + 14), (int)(y + 1), (int)(x + 15), (int)(y + 15), (int)topGlowColor, (int)bottomGlowColor);
            GuiUtils.drawGradientRect((int)-1, (int)(x + 1), (int)(y + 1), (int)(x + 15), (int)(y + 2), (int)topGlowColor, (int)topGlowColor);
            GuiUtils.drawGradientRect((int)-1, (int)(x + 1), (int)(y + 14), (int)(x + 15), (int)(y + 15), (int)bottomGlowColor, (int)bottomGlowColor);
        }
        GlStateManager.func_179121_F();
    }
}

