/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.tileentity.render;

import com.mrcrayfish.device.block.BlockPrinter;
import com.mrcrayfish.device.block.BlockRouter;
import com.mrcrayfish.device.core.network.NetworkDevice;
import com.mrcrayfish.device.core.network.Router;
import com.mrcrayfish.device.init.DeviceBlocks;
import com.mrcrayfish.device.tileentity.TileEntityRouter;
import com.mrcrayfish.device.util.CollisionHelper;
import java.util.Collection;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RouterRenderer
extends TileEntitySpecialRenderer<TileEntityRouter> {
    public void render(TileEntityRouter te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() != DeviceBlocks.ROUTER) {
            return;
        }
        if (te.isDebug()) {
            GlStateManager.func_179147_l();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179141_d();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            Router router = te.getRouter();
            BlockPos routerPos = router.getPos();
            Vec3d linePositions = this.getLineStartPosition(state);
            double startLineX = linePositions.field_72450_a;
            double startLineY = linePositions.field_72448_b;
            double startLineZ = linePositions.field_72449_c;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            Collection<NetworkDevice> DEVICES = router.getConnectedDevices((World)Minecraft.func_71410_x().field_71441_e);
            DEVICES.forEach(networkDevice -> {
                BlockPos devicePos = networkDevice.getPos();
                GL11.glLineWidth((float)14.0f);
                buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(startLineX, startLineY, startLineZ).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
                buffer.func_181662_b((double)((float)(devicePos.func_177958_n() - routerPos.func_177958_n()) + 0.5f), (double)(devicePos.func_177956_o() - routerPos.func_177956_o()), (double)((float)(devicePos.func_177952_p() - routerPos.func_177952_p()) + 0.5f)).func_181666_a(1.0f, 1.0f, 1.0f, 0.35f).func_181675_d();
                tessellator.func_78381_a();
                GL11.glLineWidth((float)4.0f);
                buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(startLineX, startLineY, startLineZ).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
                buffer.func_181662_b((double)((float)(devicePos.func_177958_n() - routerPos.func_177958_n()) + 0.5f), (double)(devicePos.func_177956_o() - routerPos.func_177956_o()), (double)((float)(devicePos.func_177952_p() - routerPos.func_177952_p()) + 0.5f)).func_181666_a(0.0f, 1.0f, 0.0f, 0.5f).func_181675_d();
                tessellator.func_78381_a();
            });
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
        }
    }

    private Vec3d getLineStartPosition(IBlockState state) {
        float lineX = 0.5f;
        float lineY = 0.1f;
        float lineZ = 0.5f;
        if (((Boolean)state.func_177229_b((IProperty)BlockRouter.VERTICAL)).booleanValue()) {
            double[] fixedPosition = CollisionHelper.fixRotation((EnumFacing)state.func_177229_b((IProperty)BlockPrinter.field_185512_D), 0.875, 0.5, 0.875, 0.5);
            lineX = (float)fixedPosition[0];
            lineY = 0.35f;
            lineZ = (float)fixedPosition[1];
        }
        return new Vec3d((double)lineX, (double)lineY, (double)lineZ);
    }
}

