/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.tileentity;

import com.mrcrayfish.device.DeviceConfig;
import com.mrcrayfish.device.core.network.Connection;
import com.mrcrayfish.device.core.network.Router;
import com.mrcrayfish.device.tileentity.TileEntityDevice;
import com.mrcrayfish.device.util.IColored;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class TileEntityNetworkDevice
extends TileEntityDevice
implements ITickable {
    private int counter;
    private Connection connection;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.connection != null && ++this.counter >= DeviceConfig.getBeaconInterval() * 2) {
            this.connection.setRouterPos(null);
            this.counter = 0;
        }
    }

    public void connect(Router router) {
        if (router == null) {
            Router connectedRouter;
            if (this.connection != null && (connectedRouter = this.connection.getRouter(this.field_145850_b)) != null) {
                connectedRouter.removeDevice(this);
            }
            this.connection = null;
            return;
        }
        this.connection = new Connection(router);
        this.counter = 0;
        this.func_70296_d();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Nullable
    public Router getRouter() {
        return this.connection != null ? this.connection.getRouter(this.field_145850_b) : null;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public boolean receiveBeacon(Router router) {
        if (this.counter >= DeviceConfig.getBeaconInterval() * 2) {
            this.connect(router);
            return true;
        }
        if (this.connection != null && this.connection.getRouterId().equals(router.getId())) {
            this.connection.setRouterPos(router.getPos());
            this.counter = 0;
            return true;
        }
        return false;
    }

    public int getSignalStrength() {
        BlockPos routerPos = this.connection.getRouterPos();
        if (routerPos != null) {
            double level;
            double distance = Math.sqrt(this.field_174879_c.func_177957_d((double)routerPos.func_177958_n() + 0.5, (double)routerPos.func_177956_o() + 0.5, (double)routerPos.func_177952_p() + 0.5));
            return distance > (level = (double)DeviceConfig.getSignalRange() / 3.0) * 2.0 ? 2 : (distance > level ? 1 : 0);
        }
        return -1;
    }

    @Override
    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.getCustomName());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.connection != null) {
            compound.func_74782_a("connection", (NBTBase)this.connection.toTag());
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("connection", 10)) {
            this.connection = Connection.fromTag(this, compound.func_74775_l("connection"));
        }
    }

    public static abstract class Colored
    extends TileEntityNetworkDevice
    implements IColored {
        private EnumDyeColor color = EnumDyeColor.RED;

        @Override
        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            if (compound.func_150297_b("color", 1)) {
                this.color = EnumDyeColor.func_176764_b((int)compound.func_74771_c("color"));
            }
        }

        @Override
        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            compound.func_74774_a("color", (byte)this.color.func_176765_a());
            return compound;
        }

        @Override
        public NBTTagCompound writeSyncTag() {
            NBTTagCompound tag = super.writeSyncTag();
            tag.func_74774_a("color", (byte)this.color.func_176765_a());
            return tag;
        }

        @Override
        public final void setColor(EnumDyeColor color) {
            this.color = color;
        }

        @Override
        public final EnumDyeColor getColor() {
            return this.color;
        }
    }
}

