/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system.task;

import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.api.utils.BankUtil;
import com.mrcrayfish.device.programs.system.object.Account;
import com.mrcrayfish.device.util.InventoryUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TaskDeposit
extends Task {
    private int amount;

    protected TaskDeposit() {
        super("bank_deposit");
    }

    public TaskDeposit(int amount) {
        this();
        this.amount = amount;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74768_a("amount", this.amount);
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        Account account = BankUtil.INSTANCE.getAccount(player);
        int amount = nbt.func_74762_e("amount");
        long value = account.getBalance() + amount;
        if (value > Integer.MAX_VALUE) {
            amount = Integer.MAX_VALUE - account.getBalance();
        }
        if (InventoryUtil.removeItemWithAmount(player, Items.field_151166_bC, amount) && account.deposit(amount)) {
            this.amount = account.getBalance();
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
        nbt.func_74768_a("balance", this.amount);
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
    }
}

