/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system.layout;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.IIcon;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.core.Laptop;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class StandardLayout
extends Layout {
    private String title;
    protected Application app;
    private Layout previous;
    private IIcon icon;

    public StandardLayout(String title, int width, int height, Application app, @Nullable Layout previous) {
        super(width, height);
        this.title = title;
        this.app = app;
        this.previous = previous;
    }

    @Override
    public void init() {
        if (this.previous != null) {
            Button btnBack = new Button(2, 2, Icons.ARROW_LEFT);
            btnBack.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.app.setCurrentLayout(this.previous);
                }
            });
            this.addComponent(btnBack);
        }
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getHeaderColor());
        Gui.func_73734_a((int)x, (int)y, (int)(x + this.width), (int)(y + 20), (int)color.getRGB());
        Gui.func_73734_a((int)x, (int)(y + 20), (int)(x + this.width), (int)(y + 21), (int)color.darker().getRGB());
        if (this.previous == null && this.icon != null) {
            this.icon.draw(mc, x + 5, y + 5);
        }
        mc.field_71466_p.func_175065_a(this.title, (float)(x + 5 + (this.previous != null || this.icon != null ? 16 : 0)), (float)(y + 7), Color.WHITE.getRGB(), true);
        super.render(laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
    }

    public void setIcon(IIcon icon) {
        this.icon = icon;
    }
}

