/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system.layout;

import com.google.common.collect.Lists;
import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.ScrollableLayout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.Image;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.programs.gitweb.component.GitWebFrame;
import com.mrcrayfish.device.programs.system.ApplicationAppStore;
import com.mrcrayfish.device.programs.system.component.SlideShow;
import com.mrcrayfish.device.programs.system.object.AppEntry;
import com.mrcrayfish.device.programs.system.object.LocalEntry;
import com.mrcrayfish.device.programs.system.object.RemoteEntry;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import java.net.URI;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class LayoutAppPage
extends Layout {
    private Laptop laptop;
    private AppEntry entry;
    private ApplicationAppStore store;
    private Image imageBanner;
    private Image imageIcon;
    private Label labelTitle;
    private Label labelVersion;
    private boolean installed;

    public LayoutAppPage(Laptop laptop, AppEntry entry, ApplicationAppStore store) {
        super(250, 150);
        this.laptop = laptop;
        this.entry = entry;
        this.store = store;
    }

    @Override
    public void init() {
        if (this.entry instanceof LocalEntry) {
            this.installed = Laptop.getSystem().getInstalledApplications().contains(((LocalEntry)this.entry).getInfo());
        }
        this.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getBackgroundColor());
            Gui.func_73734_a((int)x, (int)(y + 40), (int)(x + width), (int)(y + 41), (int)color.brighter().getRGB());
            Gui.func_73734_a((int)x, (int)(y + 41), (int)(x + width), (int)(y + 60), (int)color.getRGB());
            Gui.func_73734_a((int)x, (int)(y + 60), (int)(x + width), (int)(y + 61), (int)color.darker().getRGB());
        });
        ResourceLocation resource = new ResourceLocation(this.entry.getId());
        this.imageBanner = new Image(0, 0, 250, 40);
        this.imageBanner.setDrawFull(true);
        if (this.entry instanceof LocalEntry) {
            this.imageBanner.setImage(new ResourceLocation(resource.func_110624_b(), "textures/app/banner/" + resource.func_110623_a() + ".png"));
        } else if (this.entry instanceof RemoteEntry) {
            this.imageBanner.setImage("https://raw.githubusercontent.com/MrCrayfish/DeviceMod-CertifiedApps/master/assets/" + resource.func_110624_b() + "/" + resource.func_110623_a() + "/banner.png");
        }
        this.addComponent(this.imageBanner);
        if (this.entry instanceof LocalEntry) {
            LocalEntry localEntry = (LocalEntry)this.entry;
            AppInfo info = localEntry.getInfo();
            this.imageIcon = new Image(5, 26, 28, 28, info.getIconU(), info.getIconV(), 14, 14, 224, 224, Laptop.ICON_TEXTURES);
        } else if (this.entry instanceof RemoteEntry) {
            this.imageIcon = new Image(5, 26, 28, 28, "https://raw.githubusercontent.com/MrCrayfish/DeviceMod-CertifiedApps/master/assets/" + resource.func_110624_b() + "/" + resource.func_110623_a() + "/icon.png");
        }
        this.addComponent(this.imageIcon);
        if (this.store.certifiedApps.contains(this.entry)) {
            int width2 = Laptop.fontRenderer.func_78256_a(this.entry.getName()) * 2;
            Image certifiedIcon = new Image(38 + width2 + 3, 29, 20, 20, Icons.VERIFIED);
            this.addComponent(certifiedIcon);
        }
        this.labelTitle = new Label(this.entry.getName(), 38, 32);
        this.labelTitle.setScale(2.0);
        this.addComponent(this.labelTitle);
        String version = this.entry instanceof LocalEntry ? "v" + this.entry.getVersion() + " - " + this.entry.getAuthor() : this.entry.getAuthor();
        this.labelVersion = new Label(version, 38, 50);
        this.addComponent(this.labelVersion);
        String description = GitWebFrame.parseFormatting(this.entry.getDescription());
        ScrollableLayout descriptionLayout = ScrollableLayout.create(130, 67, 115, 78, description);
        this.addComponent(descriptionLayout);
        SlideShow slideShow = new SlideShow(5, 67, 120, 78);
        if (this.entry instanceof LocalEntry) {
            if (this.entry.getScreenshots() != null) {
                for (String image : this.entry.getScreenshots()) {
                    if (image.startsWith("http://") || image.startsWith("https://")) {
                        slideShow.addImage(image);
                        continue;
                    }
                    slideShow.addImage(new ResourceLocation(image));
                }
            }
        } else if (this.entry instanceof RemoteEntry) {
            RemoteEntry remoteEntry = (RemoteEntry)this.entry;
            String screenshotUrl = "https://raw.githubusercontent.com/MrCrayfish/DeviceMod-CertifiedApps/master/assets/" + resource.func_110624_b() + "/" + resource.func_110623_a() + "/screenshots/screenshot_%d.png";
            for (int i = 0; i < remoteEntry.screenshots; ++i) {
                slideShow.addImage(String.format(screenshotUrl, i));
            }
        }
        this.addComponent(slideShow);
        if (this.entry instanceof LocalEntry) {
            AppInfo info = ((LocalEntry)this.entry).getInfo();
            Button btnInstall = new Button(20, 2, this.installed ? "Delete" : "Install", this.installed ? Icons.CROSS : Icons.PLUS);
            btnInstall.setSize(55, 16);
            btnInstall.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    if (this.installed) {
                        this.laptop.removeApplication(info, (o, success) -> {
                            btnInstall.setText("Install");
                            btnInstall.setIcon(Icons.PLUS);
                            this.installed = false;
                        });
                    } else {
                        this.laptop.installApplication(info, (o, success) -> {
                            btnInstall.setText("Delete");
                            btnInstall.setIcon(Icons.CROSS);
                            this.installed = true;
                        });
                    }
                }
            });
            this.addComponent(btnInstall);
        } else if (this.entry instanceof RemoteEntry) {
            Button btnDownload = new Button(20, 2, "Download", Icons.IMPORT);
            btnDownload.setSize(66, 16);
            btnDownload.setClickListener((mouseX, mouseY, mouseButton) -> this.openWebLink("https://minecraft.curseforge.com/projects/" + ((RemoteEntry)this.entry).project_id));
            this.addComponent(btnDownload);
        }
    }

    @Override
    public void renderOverlay(Laptop laptop, Minecraft mc, int mouseX, int mouseY, boolean windowActive) {
        int width;
        super.renderOverlay(laptop, mc, mouseX, mouseY, windowActive);
        if (this.store.certifiedApps.contains(this.entry) && GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition + 38 + (width = Laptop.fontRenderer.func_78256_a(this.entry.getName()) * 2) + 3, this.yPosition + 29, 20, 20)) {
            laptop.func_146283_a(Lists.newArrayList((Object[])new String[]{TextFormatting.GREEN + "Certified App"}), mouseX, mouseY);
        }
    }

    private void openWebLink(String url) {
        try {
            URI uri = new URL(url).toURI();
            Class<?> class_ = Class.forName("java.awt.Desktop");
            Object object = class_.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            class_.getMethod("browse", URI.class).invoke(object, uri);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            MrCrayfishDeviceMod.getLogger().error("Couldn't open link: {}", (Object)(throwable == null ? "<UNKNOWN>" : throwable.getMessage()));
        }
    }
}

