/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.gitweb.module;

import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.programs.gitweb.component.GitWebFrame;
import com.mrcrayfish.device.programs.gitweb.module.Module;
import java.util.Map;

public class HeaderModule
extends Module {
    @Override
    public String[] getRequiredData() {
        return new String[]{"text"};
    }

    @Override
    public String[] getOptionalData() {
        return new String[]{"scale", "padding", "align"};
    }

    @Override
    public int calculateHeight(Map<String, String> data, int width) {
        if (data.containsKey("scale")) {
            return Integer.parseInt(data.get("scale")) * Laptop.fontRenderer.field_78288_b + 10;
        }
        return Laptop.fontRenderer.field_78288_b + (data.containsKey("padding") ? Integer.parseInt(data.get("padding")) : 5) * 2;
    }

    @Override
    public void generate(GitWebFrame frame, Layout layout, int width, Map<String, String> data) {
        int padding = data.containsKey("padding") ? Integer.parseInt(data.get("padding")) : 5;
        String s = GitWebFrame.parseFormatting(data.get("text"));
        Label label = new Label(s, width / 2, padding);
        label.setAlignment(2);
        int scale = 1;
        if (data.containsKey("scale")) {
            scale = Integer.parseInt(data.get("scale"));
        }
        label.setScale(scale);
        String align = data.getOrDefault("align", "center");
        if ("left".equals(align)) {
            label.left = padding;
            label.setAlignment(0);
        } else if ("right".equals(align)) {
            label.left = width - padding;
            label.setAlignment(1);
        }
        layout.addComponent(label);
    }
}

