/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.auction.task;

import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.api.utils.BankUtil;
import com.mrcrayfish.device.programs.auction.AuctionManager;
import com.mrcrayfish.device.programs.auction.object.AuctionItem;
import com.mrcrayfish.device.programs.system.object.Account;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TaskBuyItem
extends Task {
    private UUID id;

    public TaskBuyItem() {
        super("minebay_buy_item");
    }

    public TaskBuyItem(UUID id) {
        this();
        this.id = id;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74778_a("id", this.id.toString());
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        this.id = UUID.fromString(nbt.func_74779_i("id"));
        AuctionItem item = AuctionManager.INSTANCE.getItem(this.id);
        if (item != null && item.isValid()) {
            Account seller;
            int price = item.getPrice();
            Account buyer = BankUtil.INSTANCE.getAccount(player);
            if (buyer.pay(seller = BankUtil.INSTANCE.getAccount(item.getSellerId()), price)) {
                item.setSold();
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, item.getStack().func_77946_l()));
                this.setSuccessful();
            }
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
    }
}

