/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.io;

import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.io.Drive;
import com.mrcrayfish.device.api.io.Folder;
import com.mrcrayfish.device.api.task.Callback;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.io.ServerFolder;
import com.mrcrayfish.device.core.io.action.FileAction;
import com.mrcrayfish.device.core.io.drive.AbstractDrive;
import com.mrcrayfish.device.core.io.drive.ExternalDrive;
import com.mrcrayfish.device.core.io.drive.InternalDrive;
import com.mrcrayfish.device.core.io.task.TaskGetFiles;
import com.mrcrayfish.device.core.io.task.TaskGetMainDrive;
import com.mrcrayfish.device.core.io.task.TaskSendAction;
import com.mrcrayfish.device.init.DeviceItems;
import com.mrcrayfish.device.tileentity.TileEntityLaptop;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FileSystem {
    public static final Pattern PATTERN_FILE_NAME = Pattern.compile("^[\\w'. ]{1,32}$");
    public static final Pattern PATTERN_DIRECTORY = Pattern.compile("^(/)|(/[\\w'. ]{1,32})*$");
    public static final String DIR_ROOT = "/";
    public static final String DIR_APPLICATION_DATA = "/Application Data";
    public static final String DIR_HOME = "/Home";
    public static final String LAPTOP_DRIVE_NAME = "Root";
    private AbstractDrive mainDrive = null;
    private Map<UUID, AbstractDrive> additionalDrives = new HashMap<UUID, AbstractDrive>();
    private AbstractDrive attachedDrive = null;
    private EnumDyeColor attachedDriveColor = EnumDyeColor.RED;
    private TileEntityLaptop tileEntity;

    public FileSystem(TileEntityLaptop tileEntity, NBTTagCompound fileSystemTag) {
        this.tileEntity = tileEntity;
        this.load(fileSystemTag);
    }

    private void load(NBTTagCompound fileSystemTag) {
        if (fileSystemTag.func_150297_b("main_drive", 10)) {
            this.mainDrive = InternalDrive.fromTag(fileSystemTag.func_74775_l("main_drive"));
        }
        if (fileSystemTag.func_150297_b("drives", 9)) {
            NBTTagList tagList = fileSystemTag.func_150295_c("drives", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound driveTag = tagList.func_150305_b(i);
                AbstractDrive drive = InternalDrive.fromTag(driveTag.func_74775_l("drive"));
                this.additionalDrives.put(drive.getUUID(), drive);
            }
        }
        if (fileSystemTag.func_150297_b("external_drive", 10)) {
            this.attachedDrive = ExternalDrive.fromTag(fileSystemTag.func_74775_l("external_drive"));
        }
        if (fileSystemTag.func_150297_b("external_drive_color", 1)) {
            this.attachedDriveColor = EnumDyeColor.func_176764_b((int)fileSystemTag.func_74771_c("external_drive_color"));
        }
        this.setupDefault();
    }

    private void setupDefault() {
        if (this.mainDrive == null) {
            InternalDrive drive = new InternalDrive(LAPTOP_DRIVE_NAME);
            ServerFolder root = drive.getRoot(this.tileEntity.func_145831_w());
            root.add(this.createProtectedFolder("Home"), false);
            root.add(this.createProtectedFolder("Application Data"), false);
            this.mainDrive = drive;
            this.tileEntity.func_70296_d();
        }
    }

    private ServerFolder createProtectedFolder(String name) {
        try {
            Constructor constructor = ServerFolder.class.getDeclaredConstructor(String.class, Boolean.TYPE);
            constructor.setAccessible(true);
            return (ServerFolder)constructor.newInstance(name, true);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendAction(Drive drive, FileAction action, @Nullable Callback<Response> callback) {
        if (Laptop.getPos() != null) {
            TaskSendAction task = new TaskSendAction(drive, action);
            task.setCallback((nbt, success) -> {
                if (callback != null) {
                    callback.execute(Response.fromTag(nbt.func_74775_l("response")), success);
                }
            });
            TaskManager.sendTask(task);
        }
    }

    public Response readAction(String driveUuid, FileAction action, World world) {
        UUID uuid = UUID.fromString(driveUuid);
        AbstractDrive drive = this.getAvailableDrives(world, true).get(uuid);
        if (drive != null) {
            Response response = drive.handleFileAction(this, action, world);
            if (response.getStatus() == 1) {
                this.tileEntity.func_70296_d();
            }
            return response;
        }
        return FileSystem.createResponse(7, "Drive unavailable or missing");
    }

    public AbstractDrive getMainDrive() {
        return this.mainDrive;
    }

    public Map<UUID, AbstractDrive> getAvailableDrives(World world, boolean includeMain) {
        LinkedHashMap<UUID, AbstractDrive> drives = new LinkedHashMap<UUID, AbstractDrive>();
        if (includeMain) {
            drives.put(this.mainDrive.getUUID(), this.mainDrive);
        }
        this.additionalDrives.forEach(drives::put);
        if (this.attachedDrive != null) {
            drives.put(this.attachedDrive.getUUID(), this.attachedDrive);
        }
        return drives;
    }

    public boolean setAttachedDrive(ItemStack flashDrive) {
        NBTTagCompound flashDriveTag;
        AbstractDrive drive;
        if (this.attachedDrive == null && (drive = ExternalDrive.fromTag((flashDriveTag = this.getExternalDriveTag(flashDrive)).func_74775_l("drive"))) != null) {
            drive.setName(flashDrive.func_82833_r());
            this.attachedDrive = drive;
            this.attachedDriveColor = EnumDyeColor.func_176764_b((int)flashDrive.func_77960_j());
            this.tileEntity.getPipeline().func_74774_a("external_drive_color", (byte)this.attachedDriveColor.func_176765_a());
            this.tileEntity.sync();
            return true;
        }
        return false;
    }

    public AbstractDrive getAttachedDrive() {
        return this.attachedDrive;
    }

    public EnumDyeColor getAttachedDriveColor() {
        return this.attachedDriveColor;
    }

    @Nullable
    public ItemStack removeAttachedDrive() {
        if (this.attachedDrive != null) {
            ItemStack stack = new ItemStack(DeviceItems.FLASH_DRIVE, 1, this.getAttachedDriveColor().func_176765_a());
            stack.func_151001_c(this.attachedDrive.getName());
            stack.func_77978_p().func_74782_a("drive", (NBTBase)this.attachedDrive.toTag());
            this.attachedDrive = null;
            return stack;
        }
        return null;
    }

    private NBTTagCompound getExternalDriveTag(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            tagCompound.func_74782_a("drive", (NBTBase)new ExternalDrive(stack.func_82833_r()).toTag());
            stack.func_77982_d(tagCompound);
        } else if (!tagCompound.func_150297_b("drive", 10)) {
            tagCompound.func_74782_a("drive", (NBTBase)new ExternalDrive(stack.func_82833_r()).toTag());
        }
        return tagCompound;
    }

    public static void getApplicationFolder(Application app, Callback<Folder> callback) {
        if (MrCrayfishDeviceMod.proxy.hasAllowedApplications() && !MrCrayfishDeviceMod.proxy.getAllowedApplications().contains(app.getInfo())) {
            callback.execute(null, false);
            return;
        }
        if (Laptop.getMainDrive() == null) {
            TaskGetMainDrive task = new TaskGetMainDrive(Laptop.getPos());
            task.setCallback((nbt, success) -> {
                if (success) {
                    FileSystem.setupApplicationFolder(app, callback);
                } else {
                    callback.execute(null, false);
                }
            });
            TaskManager.sendTask(task);
        } else {
            FileSystem.setupApplicationFolder(app, callback);
        }
    }

    private static void setupApplicationFolder(Application app, Callback<Folder> callback) {
        Folder folder = Laptop.getMainDrive().getFolder(DIR_APPLICATION_DATA);
        if (folder != null) {
            if (folder.hasFolder(app.getInfo().getFormattedId())) {
                Folder appFolder = folder.getFolder(app.getInfo().getFormattedId());
                if (appFolder.isSynced()) {
                    callback.execute(appFolder, true);
                } else {
                    TaskGetFiles task = new TaskGetFiles(appFolder, Laptop.getPos());
                    task.setCallback((nbt, success) -> {
                        if (success && nbt.func_150297_b("files", 9)) {
                            NBTTagList files = nbt.func_150295_c("files", 10);
                            appFolder.syncFiles(files);
                            callback.execute(appFolder, true);
                        } else {
                            callback.execute(null, false);
                        }
                    });
                    TaskManager.sendTask(task);
                }
            } else {
                Folder appFolder = new Folder(app.getInfo().getFormattedId());
                folder.add(appFolder, (response, success) -> {
                    if (response != null && response.getStatus() == 1) {
                        callback.execute(appFolder, true);
                    } else {
                        callback.execute(null, false);
                    }
                });
            }
        } else {
            callback.execute(null, false);
        }
    }

    public NBTTagCompound toTag() {
        NBTTagCompound fileSystemTag = new NBTTagCompound();
        if (this.mainDrive != null) {
            fileSystemTag.func_74782_a("main_drive", (NBTBase)this.mainDrive.toTag());
        }
        NBTTagList tagList = new NBTTagList();
        this.additionalDrives.forEach((k, v) -> tagList.func_74742_a((NBTBase)v.toTag()));
        fileSystemTag.func_74782_a("drives", (NBTBase)tagList);
        if (this.attachedDrive != null) {
            fileSystemTag.func_74782_a("external_drive", (NBTBase)this.attachedDrive.toTag());
            fileSystemTag.func_74774_a("external_drive_color", (byte)this.attachedDriveColor.func_176765_a());
        }
        return fileSystemTag;
    }

    public static Response createSuccessResponse() {
        return new Response(1);
    }

    public static Response createResponse(int status, String message) {
        return new Response(status, message);
    }

    public static class Status {
        public static final int FAILED = 0;
        public static final int SUCCESSFUL = 1;
        public static final int FILE_INVALID = 2;
        public static final int FILE_IS_PROTECTED = 3;
        public static final int FILE_EXISTS = 4;
        public static final int FILE_INVALID_NAME = 5;
        public static final int FILE_INVALID_DATA = 6;
        public static final int DRIVE_UNAVAILABLE = 7;
    }

    public static class Response {
        private final int status;
        private String message = "";

        private Response(int status) {
            this.status = status;
        }

        private Response(int status, String message) {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public NBTTagCompound toTag() {
            NBTTagCompound responseTag = new NBTTagCompound();
            responseTag.func_74768_a("status", this.status);
            responseTag.func_74778_a("message", this.message);
            return responseTag;
        }

        public static Response fromTag(NBTTagCompound responseTag) {
            return new Response(responseTag.func_74762_e("status"), responseTag.func_74779_i("message"));
        }
    }
}

