/*
 * Decompiled with CFR 0.152.
 */
package chylex.customwindowtitle;

import chylex.customwindowtitle.TokenException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class TitleTokens {
    private static final Map<String, Function<String[], String>> tokenMap = new HashMap<String, Function<String[], String>>();

    public static void registerToken(String token, Function<String[], String> processor) {
        tokenMap.putIfAbsent(token, processor);
    }

    public static Function<String[], String> getTokenFunction(String token) {
        return tokenMap.getOrDefault(token, args -> null);
    }

    public static Function<String[], String> noArgs(Supplier<String> func) {
        return args -> ((String[])args).length > 0 ? TitleTokens.fail("expected no arguments, got " + ((String[])args).length) : (String)func.get();
    }

    public static Function<String[], String> oneArg(UnaryOperator<String> func) {
        return args -> ((String[])args).length != 1 ? TitleTokens.fail("expected 1 argument, got " + ((String[])args).length) : (String)func.apply(args[0]);
    }

    public static Function<String[], String> rangeArgs(int min, int max, Function<String[], String> func) {
        return args -> ((String[])args).length < min || ((String[])args).length > max ? TitleTokens.fail("expected between " + min + " and " + max + " arguments, got " + ((String[])args).length) : (String)func.apply((String[])args);
    }

    private static String fail(String message) {
        throw new TokenException(message);
    }

    private TitleTokens() {
    }
}

