/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.google.common.base.Optional;
import com.inventorypets.InventoryPets;
import com.inventorypets.ModSoundEvents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class EntityAnvilPet
extends EntityLiving
implements IMob {
    private static final DataParameter<Integer> SLIME_SIZE = EntityDataManager.func_187226_a(EntitySlime.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnvilPet.class, (DataSerializer)DataSerializers.field_187203_m);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private int deathDelay;
    private boolean wasOnGround;
    private static final String __OBFID = "CL_00001698";

    public EntityAnvilPet(World worldIn) {
        super(worldIn);
        this.field_70765_h = new SlimeMoveHelper(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
        this.setSlimeSize(1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLIME_SIZE, (Object)1);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.deathDelay = 2400;
    }

    protected void setSlimeSize(int size) {
        this.field_70180_af.func_187227_b(SLIME_SIZE, (Object)size);
        this.func_70105_a(0.51000005f * (float)size, 0.51000005f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)(0.3f + 0.1f * (float)size));
        this.func_70606_j(200.0f);
        this.field_70728_aV = size;
    }

    public int getSlimeSize() {
        return (Integer)this.field_70180_af.func_187225_a(SLIME_SIZE);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Size", this.getSlimeSize() - 1);
        tagCompound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        int i = compound.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSlimeSize(i + 1);
        this.wasOnGround = compound.func_74767_n("wasOnGround");
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public boolean isSmallSlime() {
        return this.getSlimeSize() <= 1;
    }

    protected EnumParticleTypes getParticleType() {
        return null;
    }

    public void removeItem(EntityPlayer ep, ItemStack removeitem) {
        InventoryPlayer inventoryPlayer = ep.field_71071_by;
        for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
            ItemStack j;
            if (inventoryPlayer.func_70301_a(i) == ItemStack.field_190927_a || (j = inventoryPlayer.func_70301_a(i)) == ItemStack.field_190927_a || j.func_77973_b() != removeitem.func_77973_b()) continue;
            inventoryPlayer.func_70299_a(i, ItemStack.field_190927_a);
            break;
        }
    }

    protected SoundEvent getJumpSound() {
        return ModSoundEvents.boing;
    }

    public void func_70071_h_() {
        --this.deathDelay;
        if (this.deathDelay <= 0) {
            this.field_70128_L = true;
        } else if (this.deathDelay == 90 || this.deathDelay == 60 || this.deathDelay == 30) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.overbell, SoundCategory.PLAYERS, 0.6f, 1.0f);
        } else if (this.deathDelay < 20) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.field_70170_p;
                EnumParticleTypes enumparticletypes = this.getParticleType();
                double d0 = this.field_70165_t + (double)f2;
                double d = this.field_70161_v + (double)f3;
            }
            if (this.makesSoundOnLand()) {
                this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 0.5f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    protected EntityAnvilPet createInstance() {
        return new EntityAnvilPet(this.field_70170_p);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SLIME_SIZE.equals(key)) {
            int i = this.getSlimeSize();
            this.func_70105_a(0.51000005f * (float)i, 0.51000005f * (float)i);
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(key);
    }

    public void func_70106_y() {
        int i = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityAnvilPet EntityAnvilPet2 = this.createInstance();
                if (this.func_145818_k_()) {
                    EntityAnvilPet2.func_96094_a(this.func_95999_t());
                }
                if (this.func_104002_bU()) {
                    EntityAnvilPet2.func_110163_bv();
                }
                EntityAnvilPet2.setSlimeSize(i / 2);
                EntityAnvilPet2.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)EntityAnvilPet2);
            }
        }
        super.func_70106_y();
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (itemstack != ItemStack.field_190927_a) {
            boolean odFlag = false;
            if (InventoryPets.petsEatWholeItems) {
                odFlag = false;
                for (ItemStack ironNugget : OreDictionary.getOres((String)"ingotIron")) {
                    if (!OreDictionary.itemMatches((ItemStack)itemstack, (ItemStack)ironNugget, (boolean)true)) continue;
                    odFlag = true;
                }
            } else {
                odFlag = false;
                for (ItemStack ironNugget : OreDictionary.getOres((String)"nuggetIron")) {
                    if (!OreDictionary.itemMatches((ItemStack)itemstack, (ItemStack)ironNugget, (boolean)true)) continue;
                    odFlag = true;
                }
            }
            boolean eatFlag = false;
            if (odFlag) {
                ItemStack itemchk2;
                for (int j = 0; j < entityplayer.field_71071_by.func_70302_i_(); ++j) {
                    itemchk2 = entityplayer.field_71071_by.func_70301_a(j);
                    if (itemchk2 == ItemStack.field_190927_a || !itemchk2.func_77973_b().isRepairable() || !itemchk2.func_77951_h() || itemchk2.func_77977_a().contains("_pet") || itemchk2.func_77977_a().contains("_canteen")) continue;
                    itemchk2.func_77964_b(itemchk2.func_77952_i() - 30);
                    this.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.anvil, SoundCategory.PLAYERS, 0.1f, 1.2f);
                    eatFlag = true;
                }
                for (int j1 = 100; j1 <= 103; ++j1) {
                    itemchk2 = entityplayer.field_71071_by.func_70301_a(j1);
                    if (itemchk2 == ItemStack.field_190927_a || !itemchk2.func_77973_b().isRepairable() || !itemchk2.func_77951_h() || itemchk2.func_77977_a().contains("_pet")) continue;
                    itemchk2.func_77964_b(itemchk2.func_77952_i() - 30);
                    this.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.anvil, SoundCategory.PLAYERS, 0.1f, 1.2f);
                    if (entityplayer.field_71075_bZ.field_75098_d) continue;
                    eatFlag = false;
                }
                if (eatFlag) {
                    this.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, ModSoundEvents.nomnom, SoundCategory.PLAYERS, 0.6f, 1.2f);
                }
                if (!entityplayer.field_71075_bZ.field_75098_d && eatFlag) {
                    itemstack.func_190920_e(itemstack.func_190916_E() - 1);
                    if (itemstack.func_190916_E() == 0) {
                        this.removeItem(entityplayer, itemstack);
                    }
                }
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && itemstack == ItemStack.field_190927_a) {
            if (InventoryPets.petsEatWholeItems) {
                entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("info.ip.livinganvilinteracthc", new Object[0]), true);
            } else {
                entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("info.ip.livinganvilinteract", new Object[0]), true);
            }
            return true;
        }
        return super.func_184645_a(entityplayer, hand);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (this.canDamagePlayer()) {
            this.dealDamage((EntityLivingBase)entityIn);
        }
    }

    protected void dealDamage(EntityLivingBase p_175451_1_) {
        int i = this.getSlimeSize();
        if (this.func_70685_l((Entity)p_175451_1_) && this.func_70068_e((Entity)p_175451_1_) < 0.6 * (double)i * 0.6 * (double)i && p_175451_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
            this.func_174815_a((EntityLivingBase)this, (Entity)p_175451_1_);
        }
    }

    public float func_70047_e() {
        return 1.0f * this.field_70131_O;
    }

    protected boolean canDamagePlayer() {
        return this.getSlimeSize() > 1;
    }

    protected int getAttackStrength() {
        return this.getSlimeSize();
    }

    protected SoundEvent getHurtSound() {
        return ModSoundEvents.clang;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.clang;
    }

    protected SoundEvent getSquishSound() {
        return ModSoundEvents.boing;
    }

    protected Item func_146068_u() {
        return Items.field_191525_da;
    }

    public boolean func_70601_bi() {
        return true;
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSlimeSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.42f;
        this.field_70160_al = true;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f * difficulty.func_180170_c()) {
            ++i;
        }
        int j = 1 << i;
        this.setSlimeSize(j);
        return super.func_180482_a(difficulty, livingdata);
    }

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private EntityAnvilPet slime;
        private boolean isAggressive;

        public SlimeMoveHelper(EntityAnvilPet p_i45821_1_) {
            super((EntityLiving)p_i45821_1_);
            this.slime = p_i45821_1_;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.slime.field_191988_bg = 0.0f;
                        this.slime.field_70702_br = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private EntityAnvilPet slime;

        public AISlimeHop(EntityAnvilPet p_i45822_1_) {
            this.slime = p_i45822_1_;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            boolean chkPlayer = false;
            EntityPlayer entityplayer = null;
            if (!(this.slime.func_70638_az() instanceof EntityPlayer)) {
                return false;
            }
            entityplayer = (EntityPlayer)this.slime.func_70638_az();
            if (entityplayer != null) {
                int x = (int)entityplayer.field_70165_t;
                int z = (int)entityplayer.field_70161_v;
                int thisx = (int)this.slime.field_70165_t;
                int thisz = (int)this.slime.field_70161_v;
                chkPlayer = Math.abs(thisx - x) >= 3 || Math.abs(thisz - z) >= 3;
            }
            if (entityplayer != null) {
                this.slime.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
            }
            return chkPlayer;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private EntityAnvilPet slime;

        public AISlimeFloat(EntityAnvilPet p_i45823_1_) {
            this.slime = p_i45823_1_;
            this.func_75248_a(5);
            ((PathNavigateGround)p_i45823_1_.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AISlimeFaceRandom
    extends EntityAIBase {
        private EntityAnvilPet slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AISlimeFaceRandom(EntityAnvilPet p_i45820_1_) {
            this.slime = p_i45820_1_;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab());
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AISlimeAttack
    extends EntityAIBase {
        private EntityAnvilPet slime;
        private int growTieredTimer;

        public AISlimeAttack(EntityAnvilPet p_i45824_1_) {
            this.slime = p_i45824_1_;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a);
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean continueExecuting() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a ? false : --this.growTieredTimer > 0));
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
        }
    }
}

