/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client.texture;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.util.UUIDTypeAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.lwjgl.util.Point;
import uk.kihira.tails.client.PartRegistry;
import uk.kihira.tails.client.texture.TripleTintTexture;
import uk.kihira.tails.common.PartInfo;
import uk.kihira.tails.common.PartsData;
import uk.kihira.tails.common.Tails;
import uk.kihira.tails.common.network.PlayerDataMessage;

@SideOnly(value=Side.CLIENT)
public class TextureHelper {
    private static final int switch1Colour = -61200;
    private static final int switch2Colour = -4661120;
    private static final Point[] dataPoints = new Point[]{new Point(58, 16), new Point(58, 17), new Point(58, 18)};
    private static final Point[][] switchPoints = new Point[][]{{new Point(56, 16), new Point(57, 16)}, {new Point(56, 17), new Point(57, 17)}, {new Point(56, 18), new Point(57, 18)}, {new Point(56, 19), new Point(57, 19)}};
    private static final Point[][] tintPoints = new Point[][]{{new Point(59, 16), new Point(60, 16), new Point(61, 16)}, {new Point(59, 17), new Point(60, 17), new Point(61, 17)}, {new Point(59, 18), new Point(60, 18), new Point(61, 18)}};

    public static boolean hasSkinData(AbstractClientPlayer player) {
        BufferedImage image = TextureHelper.getPlayerSkinAsBufferedImage(player);
        if (image != null) {
            for (PartsData.PartType partType : PartsData.PartType.values()) {
                int ordinal = partType.ordinal();
                int scol1 = image.getRGB(switchPoints[ordinal][0].getX(), switchPoints[ordinal][0].getY());
                int scol2 = image.getRGB(switchPoints[ordinal][1].getX(), switchPoints[ordinal][1].getY());
                if (scol1 != -61200 || scol2 != -4661120) continue;
                return true;
            }
        }
        return false;
    }

    public static void buildPlayerPartsData(AbstractClientPlayer player) {
        GameProfile profile = player.func_146103_bH();
        UUID uuid = profile.getId();
        BufferedImage image = TextureHelper.getPlayerSkinAsBufferedImage(player);
        if (image != null) {
            PartsData partsData = Tails.proxy.getPartsData(uuid);
            if (partsData == null) {
                partsData = new PartsData();
            }
            for (PartsData.PartType partType : PartsData.PartType.values()) {
                int ordinal = partType.ordinal();
                int scol1 = image.getRGB(switchPoints[ordinal][0].getX(), switchPoints[ordinal][0].getY());
                int scol2 = image.getRGB(switchPoints[ordinal][1].getX(), switchPoints[ordinal][1].getY());
                PartInfo tailInfo = scol1 == -61200 && scol2 == -4661120 ? TextureHelper.buildPartInfoFromSkin(partType, image, player.func_110124_au()) : PartInfo.none(partType);
                partsData.setPartInfo(partType, tailInfo);
            }
            Tails.proxy.addPartsData(uuid, partsData);
            if (player == Minecraft.func_71410_x().field_71439_g) {
                Tails.setLocalPartsData(partsData);
                Tails.networkWrapper.sendToServer((IMessage)new PlayerDataMessage(UUIDTypeAdapter.fromString((String)Minecraft.func_71410_x().func_110432_I().func_148255_b()), partsData, false));
            }
        }
    }

    public static BufferedImage writePartsDataToSkin(PartsData partsData, AbstractClientPlayer player) {
        BufferedImage image = TextureHelper.getPlayerSkinAsBufferedImage(player);
        if (image != null) {
            for (PartsData.PartType partType : PartsData.PartType.values()) {
                PartInfo partInfo = partsData.getPartInfo(partType);
                int ordinal = partType.ordinal();
                int switch1 = 0;
                int switch2 = 0;
                if (partInfo != null) {
                    if (partInfo.hasPart) {
                        switch1 = -61200;
                        switch2 = -4661120;
                    }
                    int dataColour = -16777216;
                    dataColour |= partInfo.typeid << 16;
                    dataColour |= partInfo.subid << 8;
                    image.setRGB(dataPoints[ordinal].getX(), dataPoints[ordinal].getY(), dataColour |= partInfo.textureID);
                    image.setRGB(tintPoints[ordinal][0].getX(), tintPoints[ordinal][0].getY(), partInfo.tints[0]);
                    image.setRGB(tintPoints[ordinal][1].getX(), tintPoints[ordinal][1].getY(), partInfo.tints[1]);
                    image.setRGB(tintPoints[ordinal][2].getX(), tintPoints[ordinal][2].getY(), partInfo.tints[2]);
                }
                image.setRGB(switchPoints[ordinal][0].getX(), switchPoints[ordinal][0].getY(), switch1);
                image.setRGB(switchPoints[ordinal][1].getX(), switchPoints[ordinal][1].getY(), switch2);
            }
        } else {
            Tails.logger.warn("Attempted to write PartInfo to skin but player doesn't have a skin!");
        }
        return image;
    }

    private static PartInfo buildPartInfoFromSkin(PartsData.PartType partType, BufferedImage skin, UUID uuid) {
        int ordinal = partType.ordinal();
        int data = skin.getRGB(dataPoints[ordinal].getX(), dataPoints[ordinal].getY());
        int typeid = data >> 16 & 0xFF;
        int subtype = data >> 8 & 0xFF;
        int textureid = data & 0xFF;
        String[] textures = PartRegistry.getRenderPart(partType, typeid).getTextureNames(subtype);
        textureid = textureid >= textures.length ? 0 : textureid;
        int tint1 = skin.getRGB(tintPoints[ordinal][0].getX(), tintPoints[ordinal][0].getY());
        int tint2 = skin.getRGB(tintPoints[ordinal][1].getX(), tintPoints[ordinal][1].getY());
        int tint3 = skin.getRGB(tintPoints[ordinal][2].getX(), tintPoints[ordinal][2].getY());
        ResourceLocation tailTexture = TextureHelper.generateTexture(uuid, partType, typeid, subtype, textureid, new int[]{tint1, tint2, tint3});
        return new PartInfo(true, typeid, subtype, 0, tint1, tint2, tint3, 1.0f, tailTexture, partType);
    }

    private static ResourceLocation generateTexture(UUID uuid, PartsData.PartType partType, int typeid, int subid, int textureID, int[] tints) {
        String[] textures = PartRegistry.getRenderPart(partType, typeid).getTextureNames(subid);
        textureID = textureID >= textures.length ? 0 : textureID;
        String texturePath = "texture/" + partType.name().toLowerCase() + "/" + textures[textureID] + ".png";
        ResourceLocation tailTexture = new ResourceLocation("tails_" + uuid + "_" + partType.name() + "_" + typeid + "_" + subid + "_" + textureID + "_" + tints[0] + "_" + tints[1] + "_" + tints[2]);
        Minecraft.func_71410_x().func_110434_K().func_110579_a(tailTexture, (ITextureObject)new TripleTintTexture("tails", texturePath, tints[0], tints[1], tints[2]));
        return tailTexture;
    }

    public static ResourceLocation generateTexture(UUID uuid, PartInfo partInfo) {
        return TextureHelper.generateTexture(uuid, partInfo.partType, partInfo.typeid, partInfo.subid, partInfo.textureID, partInfo.tints);
    }

    public static boolean needsBuild(EntityPlayer player) {
        return !Tails.proxy.hasPartsData(player.getPersistentID()) && player.func_146103_bH().getProperties().containsKey((Object)"textures");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getPlayerSkinAsBufferedImage(AbstractClientPlayer player) {
        BufferedImage bufferedImage = null;
        InputStream inputStream = null;
        Minecraft mc = Minecraft.func_71410_x();
        Map map = mc.func_152342_ad().func_152788_a(player.func_146103_bH());
        String playerName = player.getDisplayNameString();
        try {
            ITextureObject skintex = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? mc.func_110434_K().func_110581_b(mc.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : mc.func_110434_K().func_110581_b(player.func_110306_p());
            if (skintex instanceof ThreadDownloadImageData) {
                ThreadDownloadImageData imagedata = (ThreadDownloadImageData)skintex;
                Tails.logger.debug("Loading " + playerName + " skin");
                bufferedImage = (BufferedImage)ObfuscationReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)imagedata, (String[])new String[]{"field_110560_d", "bufferedImage"});
            } else if (skintex instanceof DynamicTexture) {
                Tails.logger.warn(playerName + " skin is a DynamicTexture! Attempting to load anyway");
                DynamicTexture imagedata = (DynamicTexture)skintex;
                int width = (Integer)ObfuscationReflectionHelper.getPrivateValue(DynamicTexture.class, (Object)imagedata, (String[])new String[]{"field_94233_j", "width"});
                int height = (Integer)ObfuscationReflectionHelper.getPrivateValue(DynamicTexture.class, (Object)imagedata, (String[])new String[]{"field_94234_k", "height"});
                bufferedImage = new BufferedImage(width, height, 2);
                bufferedImage.setRGB(0, 0, width, height, imagedata.func_110565_c(), 0, width);
            } else {
                Tails.logger.warn("Could not fetch " + playerName + " skin, loading default skin");
                inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(DefaultPlayerSkin.func_177335_a()).func_110527_b();
                bufferedImage = ImageIO.read(inputStream);
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (IOException e) {
            Tails.logger.error("Failed to read " + playerName + " skin texture", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return bufferedImage;
    }

    private static void uploadTexture(ITextureObject textureObject, BufferedImage bufferedImage) {
        TextureUtil.func_110987_a((int)textureObject.func_110552_b(), (BufferedImage)bufferedImage);
    }
}

