/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.structure;

import mod.lucky.structure.BlockPlacer;
import mod.lucky.structure.rotation.Rotations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class StructureUtils {
    public static BlockPos getWorldPos(BlockPos structPos, BlockPos structCenter, BlockPos harvestPos, int rotation) {
        return Rotations.rotatePos(harvestPos.func_177971_a((Vec3i)structPos).func_177973_b((Vec3i)structCenter), harvestPos, rotation);
    }

    public static BlockPos getWorldPos(BlockPos structPos, Vec3d structCenter, Vec3d harvestPos, int rotation) {
        return new BlockPos(StructureUtils.getWorldPos(new Vec3d((double)structPos.func_177958_n() + 0.5, (double)structPos.func_177956_o(), (double)structPos.func_177952_p() + 0.5), structCenter, harvestPos, rotation));
    }

    public static Vec3d getWorldPos(Vec3d structPos, Vec3d structCenter, Vec3d harvestPos, int rotation) {
        return Rotations.rotatePos(harvestPos.func_178787_e(structPos).func_178788_d(structCenter), harvestPos, rotation);
    }

    public static void setBlock(BlockPlacer blockPlacer, IBlockState blockState, BlockPos structPos, Vec3d structCenter, Vec3d harvestPos, int rotation) {
        blockPlacer.add(Rotations.rotateState(blockState, rotation), StructureUtils.getWorldPos(structPos, structCenter, harvestPos, rotation));
    }

    public static void setTileEntity(World world, NBTTagCompound tileEntity, BlockPos structPos, Vec3d structCenter, Vec3d harvestPos, int rotation) {
        BlockPos pos = StructureUtils.getWorldPos(structPos, structCenter, harvestPos, rotation);
        IBlockState blockState = world.func_180495_p(pos);
        world.func_175713_t(pos);
        BlockPos chunkPos = new BlockPos(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF);
        TileEntity blockTileEntity = world.func_175726_f(pos).func_177424_a(chunkPos, Chunk.EnumCreateEntityType.CHECK);
        blockTileEntity = blockState.func_177230_c().createTileEntity(world, blockState);
        blockTileEntity.func_145839_a(tileEntity);
        blockTileEntity.func_174878_a(pos);
        blockTileEntity.func_145834_a(world);
        Rotations.rotateTileEntity(blockTileEntity, rotation);
        world.func_175690_a(pos, blockTileEntity);
        blockTileEntity.func_145836_u();
    }

    public static void setTileEntity(World world, TileEntity tileEntity, Vec3d structCenter, Vec3d harvestPos, int rotation) {
        BlockPos pos = StructureUtils.getWorldPos(tileEntity.func_174877_v(), structCenter, harvestPos, rotation);
        world.func_175713_t(pos);
        tileEntity.func_174878_a(pos);
        tileEntity.func_145834_a(world);
        Rotations.rotateTileEntity(tileEntity, rotation);
        world.func_175690_a(pos, tileEntity);
    }

    public static void setEntity(World world, Entity entity, Vec3d structCenter, Vec3d harvestPos, int rotation) {
        Vec3d pos = StructureUtils.getWorldPos(entity.func_174791_d(), structCenter, harvestPos, rotation);
        entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        Rotations.rotateEntity(entity, rotation);
        world.func_72838_d(entity);
    }
}

