/*
 * Decompiled with CFR 0.152.
 */
package superbas11.menumobs.gui;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import superbas11.menumobs.MainMenuRenderTicker;
import superbas11.menumobs.gui.GuiFixedMobEntry;
import superbas11.menumobs.gui.GuiSelectFixedMob;
import superbas11.menumobs.util.LogHelper;

public abstract class FixedEntityArrayEntry
extends GuiEditArrayEntries.BaseEntry {
    private static Map<Object, String> selectableValues = FixedMobArrayEntry.getSelectableValues();
    protected Minecraft mc = Minecraft.func_71410_x();

    public FixedEntityArrayEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement) {
        super(owningScreen, owningEntryList, configElement);
    }

    public abstract Object getValue();

    public static class FixedPlayerArrayEntry
    extends FixedEntityArrayEntry {
        protected GuiTextField textFieldValue;
        protected boolean enabled = true;

        public FixedPlayerArrayEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value) {
            super(owningScreen, owningEntryList, configElement);
            this.textFieldValue = new GuiTextField(0, this.mc.field_71466_p, owningEntryList.field_148155_a / 4 + 1, 0, ((GuiFixedMobEntry.GuiEditFixedMobEntries)owningEntryList).controlWidth - 3, 16);
            this.textFieldValue.func_146203_f(10000);
            this.textFieldValue.func_146180_a(value.toString());
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            if (this.configElement.isListLengthFixed() || slotIndex != this.owningEntryList.listEntries.size() - 1) {
                this.textFieldValue.func_146189_e(true);
                this.textFieldValue.field_146210_g = y + 1;
                this.textFieldValue.func_146194_f();
            } else {
                this.textFieldValue.func_146189_e(false);
            }
        }

        public void keyTyped(char eventChar, int eventKey) {
            if (this.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textFieldValue.func_146201_a(this.enabled ? eventChar : (char)'\u0000', eventKey);
                if (this.configElement.getValidationPattern() != null) {
                    this.isValidValue = this.configElement.getValidationPattern().matcher(this.textFieldValue.func_146179_b().trim()).matches();
                }
            }
        }

        public void updateCursorCounter() {
            this.textFieldValue.func_146178_a();
        }

        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.func_146192_a(x, y, mouseEvent);
        }

        @Override
        public Object getValue() {
            return this.textFieldValue.func_146179_b().trim();
        }
    }

    public static class FixedMobArrayEntry
    extends FixedEntityArrayEntry {
        protected GuiButtonExt btnValue;
        protected Object currentValue;

        public FixedMobArrayEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value) {
            super(owningScreen, owningEntryList, configElement);
            this.btnValue = new GuiButtonExt(0, ((GuiFixedMobEntry.GuiEditFixedMobEntries)owningEntryList).controlWidth, 0, ((GuiFixedMobEntry.GuiEditFixedMobEntries)owningEntryList).controlWidth, 18, value.toString());
            this.currentValue = value.toString();
            this.updateValueButtonText();
        }

        protected static Map<Object, String> getSelectableValues() {
            TreeMap<Object, String> selectableValues = new TreeMap<Object, String>();
            for (String mobID : MainMenuRenderTicker.getEntStrings()) {
                Class clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(mobID));
                if (clazz == null) {
                    LogHelper.severe("Cannot find class of entity %s", mobID);
                    continue;
                }
                if (!EntityLivingBase.class.isAssignableFrom(clazz)) continue;
                selectableValues.put(mobID, EntityList.func_191302_a((ResourceLocation)new ResourceLocation(mobID)));
            }
            return selectableValues;
        }

        public void updateValueButtonText() {
            this.btnValue.field_146126_j = this.currentValue.equals("") ? "None" : this.currentValue.toString();
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.func_146116_c(this.mc, x, y)) {
                this.btnValue.func_146113_a(this.mc.func_147118_V());
                this.valueButtonPressed(index);
                this.updateValueButtonText();
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        public void valueButtonPressed(int slotIndex) {
            this.mc.func_147108_a((GuiScreen)new GuiSelectFixedMob((GuiScreen)this.owningScreen, this.configElement, slotIndex, selectableValues, this.currentValue, this.enabled()));
        }

        public void setValueFromChildScreen(Object newValue) {
            if (this.enabled() && this.currentValue != null ? !this.currentValue.equals(newValue) : newValue != null) {
                this.currentValue = newValue;
                this.updateValueButtonText();
            }
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.btnValue.field_146120_f = ((GuiFixedMobEntry.GuiEditFixedMobEntries)this.owningEntryList).controlWidth;
            this.btnValue.field_146128_h = listWidth / 4;
            this.btnValue.field_146129_i = y;
            this.btnValue.func_191745_a(this.mc, mouseX, mouseY, partial);
        }

        @Override
        public Object getValue() {
            return this.currentValue.toString().trim();
        }

        public boolean enabled() {
            return this.owningEntryList.func_148125_i();
        }
    }

    public static class FixedEntityOptionEntry
    extends FixedEntityArrayEntry {
        protected GuiButtonExt btnPlayer;
        protected GuiButtonExt btnEntity;

        public FixedEntityOptionEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.btnPlayer = new GuiButtonExt(0, ((GuiFixedMobEntry.GuiEditFixedMobEntries)owningEntryList).controlWidth, 0, ((GuiFixedMobEntry.GuiEditFixedMobEntries)owningEntryList).controlWidth / 2 - 2, 18, "Player");
            this.btnEntity = new GuiButtonExt(0, ((GuiFixedMobEntry.GuiEditFixedMobEntries)owningEntryList).controlWidth, 0, ((GuiFixedMobEntry.GuiEditFixedMobEntries)owningEntryList).controlWidth / 2 - 2, 18, "Entity");
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.btnPlayer.field_146120_f = ((GuiFixedMobEntry.GuiEditFixedMobEntries)this.owningEntryList).controlWidth / 2 - 2;
            this.btnPlayer.field_146128_h = listWidth / 4;
            this.btnPlayer.field_146129_i = y;
            this.btnPlayer.func_191745_a(this.mc, mouseX, mouseY, partial);
            this.btnEntity.field_146120_f = ((GuiFixedMobEntry.GuiEditFixedMobEntries)this.owningEntryList).controlWidth / 2 - 2;
            this.btnEntity.field_146128_h = listWidth / 4 + ((GuiFixedMobEntry.GuiEditFixedMobEntries)this.owningEntryList).controlWidth / 2 + 2;
            this.btnEntity.field_146129_i = y;
            this.btnEntity.func_191745_a(this.mc, mouseX, mouseY, partial);
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnPlayer.func_146116_c(this.mc, x, y)) {
                this.btnPlayer.func_146113_a(this.mc.func_147118_V());
                this.owningEntryList.listEntries.set(index, new FixedPlayerArrayEntry(this.owningScreen, this.owningEntryList, this.configElement, ""));
                return true;
            }
            if (this.btnEntity.func_146116_c(this.mc, x, y)) {
                this.btnPlayer.func_146113_a(this.mc.func_147118_V());
                this.mc.func_147108_a((GuiScreen)new GuiSelectFixedMob((GuiScreen)this.owningScreen, this.configElement, index, selectableValues, "", true));
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public Object getValue() {
            return "";
        }
    }
}

